/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.HashMap;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.DeactivateChangeLogCommand;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseDeactivateChangeLogMojo
extends AbstractLiquibaseChangeLogMojo {
    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        DeactivateChangeLogCommand deactivateChangeLogCommand = (DeactivateChangeLogCommand)CommandFactory.getInstance().getCommand("deactivateChangeLog");
        deactivateChangeLogCommand.setChangeLogFile(this.changeLogFile);
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", (String)database);
        argsMap.put("liquibase", (String)liquibase);
        argsMap.put("changeLog", (String)liquibase.getDatabaseChangeLog());
        deactivateChangeLogCommand.configure(argsMap);
        try {
            CommandResult result = deactivateChangeLogCommand.execute();
            if (!result.succeeded) {
                throw new LiquibaseException(result.message);
            }
            Scope.getCurrentScope().getUI().sendMessage(result.print());
        }
        catch (CommandExecutionException cee) {
            throw new LiquibaseException("Error executing deactivateChangeLog", (Throwable)cee);
        }
    }
}

