/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class DELETE_ACCESSSPEC
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(41);
    private static final Logger LOGGER = Logger.getLogger(DELETE_ACCESSSPEC.class);
    public static final String RESPONSETYPE = "DELETE_ACCESSSPEC_RESPONSE";
    protected UnsignedInteger accessSpecID;

    public DELETE_ACCESSSPEC() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public DELETE_ACCESSSPEC(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list.toByteArray());
    }

    public DELETE_ACCESSSPEC(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public DELETE_ACCESSSPEC(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.accessSpecID == null) {
            LOGGER.warn((Object)" accessSpecID not set");
            throw new InvalidLLRPMessageException(" accessSpecID not set  for Parameter of Type DELETE_ACCESSSPEC");
        }
        resultBits.append(this.accessSpecID.encodeBinary());
        return resultBits;
    }

    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("DELETE_ACCESSSPEC", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.accessSpecID == null) {
                LOGGER.warn((Object)" accessSpecID not set");
                throw new MissingParameterException(" accessSpecID not set");
            }
            root.addContent(this.accessSpecID.encodeXML("AccessSpecID", ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        boolean tempLength = false;
        this.accessSpecID = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        position += UnsignedInteger.length();
    }

    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID"));
            temp = root.getChild("AccessSpecID", root.getNamespace());
            if (temp == null) {
                LOGGER.warn((Object)("Element accessSpecID not provided in xml as child of " + root.getName()));
                throw new MissingParameterException("Element accessSpecID not provided");
            }
            this.accessSpecID = new UnsignedInteger(temp);
            root.removeChild("AccessSpecID", root.getNamespace());
            if (root.getChildren().size() > 0) {
                String message = "DELETE_ACCESSSPEC has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setAccessSpecID(UnsignedInteger accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public UnsignedInteger getAccessSpecID() {
        return this.accessSpecID;
    }

    public String getResponseType() {
        return RESPONSETYPE;
    }

    public String getName() {
        return "DELETE_ACCESSSPEC";
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

