/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.ReaderEventNotificationData;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class READER_EVENT_NOTIFICATION
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(63);
    private static final Logger LOGGER = Logger.getLogger(READER_EVENT_NOTIFICATION.class);
    public static final String RESPONSETYPE = "";
    protected ReaderEventNotificationData readerEventNotificationData;

    public READER_EVENT_NOTIFICATION() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public READER_EVENT_NOTIFICATION(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list.toByteArray());
    }

    public READER_EVENT_NOTIFICATION(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public READER_EVENT_NOTIFICATION(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.readerEventNotificationData == null) {
            LOGGER.warn((Object)" readerEventNotificationData not set");
            throw new InvalidLLRPMessageException(" readerEventNotificationData not set");
        }
        resultBits.append(this.readerEventNotificationData.encodeBinary());
        return resultBits;
    }

    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("READER_EVENT_NOTIFICATION", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.readerEventNotificationData == null) {
                LOGGER.info((Object)"readerEventNotificationData not set");
                throw new MissingParameterException("readerEventNotificationData not set");
            }
            root.addContent(this.readerEventNotificationData.encodeXML(this.readerEventNotificationData.getClass().getSimpleName(), ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"READER_EVENT_NOTIFICATION misses non optional parameter of type ReaderEventNotificationData");
            throw new InvalidLLRPMessageException("READER_EVENT_NOTIFICATION misses non optional parameter of type ReaderEventNotificationData");
        }
        if (binary.get(position)) {
            READER_EVENT_NOTIFICATION rEADER_EVENT_NOTIFICATION = this;
            tempLength = rEADER_EVENT_NOTIFICATION.readerEventNotificationData.length();
        }
        if (type != null && type.equals(ReaderEventNotificationData.TYPENUM)) {
            this.readerEventNotificationData = new ReaderEventNotificationData(binary.subList(position, tempLength));
            position += tempLength;
        } else {
            LOGGER.warn((Object)"READER_EVENT_NOTIFICATION misses non optional parameter of type ReaderEventNotificationData");
            throw new InvalidLLRPMessageException("READER_EVENT_NOTIFICATION misses non optional parameter of type ReaderEventNotificationData");
        }
        LOGGER.debug((Object)(" readerEventNotificationData is instantiated with ReaderEventNotificationData with length" + tempLength));
    }

    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID"));
            temp = root.getChild("ReaderEventNotificationData", ns);
            if (temp == null) {
                LOGGER.warn((Object)"READER_EVENT_NOTIFICATION misses non optional parameter of type readerEventNotificationData");
                throw new MissingParameterException("READER_EVENT_NOTIFICATION misses non optional parameter of type readerEventNotificationData");
            }
            this.readerEventNotificationData = new ReaderEventNotificationData(temp);
            LOGGER.info((Object)"setting parameter readerEventNotificationData for parameter READER_EVENT_NOTIFICATION");
            root.removeChild("ReaderEventNotificationData", ns);
            if (root.getChildren().size() > 0) {
                String message = "READER_EVENT_NOTIFICATION has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setReaderEventNotificationData(ReaderEventNotificationData readerEventNotificationData) {
        this.readerEventNotificationData = readerEventNotificationData;
    }

    public ReaderEventNotificationData getReaderEventNotificationData() {
        return this.readerEventNotificationData;
    }

    public String getResponseType() {
        return RESPONSETYPE;
    }

    public String getName() {
        return "READER_EVENT_NOTIFICATION";
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

