/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.RFSurveyReportData;
import org.llrp.ltk.generated.parameters.TagReportData;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RO_ACCESS_REPORT
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(61);
    private static final Logger LOGGER = Logger.getLogger(RO_ACCESS_REPORT.class);
    public static final String RESPONSETYPE = "";
    protected List<TagReportData> tagReportDataList = new LinkedList<TagReportData>();
    protected List<RFSurveyReportData> rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public RO_ACCESS_REPORT() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public RO_ACCESS_REPORT(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list.toByteArray());
    }

    public RO_ACCESS_REPORT(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public RO_ACCESS_REPORT(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.tagReportDataList == null) {
            LOGGER.info((Object)" tagReportDataList not set");
        } else {
            for (TagReportData tagReportData : this.tagReportDataList) {
                resultBits.append(tagReportData.encodeBinary());
            }
        }
        if (this.rFSurveyReportDataList == null) {
            LOGGER.info((Object)" rFSurveyReportDataList not set");
        } else {
            for (RFSurveyReportData rFSurveyReportData : this.rFSurveyReportDataList) {
                resultBits.append(rFSurveyReportData.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("RO_ACCESS_REPORT", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.tagReportDataList == null) {
                LOGGER.info((Object)"tagReportDataList not set");
            } else {
                for (TagReportData tagReportData : this.tagReportDataList) {
                    root.addContent(tagReportData.encodeXML(tagReportData.getClass().getName().replaceAll(tagReportData.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            if (this.rFSurveyReportDataList == null) {
                LOGGER.info((Object)"rFSurveyReportDataList not set");
            } else {
                for (RFSurveyReportData rFSurveyReportData : this.rFSurveyReportDataList) {
                    root.addContent(rFSurveyReportData.encodeXML(rFSurveyReportData.getClass().getName().replaceAll(rFSurveyReportData.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            if (this.customList == null) {
                LOGGER.info((Object)"customList not set");
            } else {
                for (Custom custom : this.customList) {
                    root.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        short tempByteLength;
        SignedShort type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.tagReportDataList = new LinkedList<TagReportData>();
        LOGGER.debug((Object)"decoding parameter tagReportDataList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(TagReportData.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = TagReportData.length();
                }
                this.tagReportDataList.add(new TagReportData(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding TagReportData to tagReportDataList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.tagReportDataList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional tagReportDataList");
        }
        this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
        LOGGER.debug((Object)"decoding parameter rFSurveyReportDataList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(RFSurveyReportData.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = RFSurveyReportData.length();
                }
                this.rFSurveyReportDataList.add(new RFSurveyReportData(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding RFSurveyReportData to rFSurveyReportDataList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.rFSurveyReportDataList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional rFSurveyReportDataList");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Object temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            List tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID"));
            this.tagReportDataList = new LinkedList<TagReportData>();
            tempList = root.getChildren("TagReportData", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"RO_ACCESS_REPORT misses optional parameter of type tagReportDataList");
            } else {
                for (Element e : tempList) {
                    this.tagReportDataList.add(new TagReportData(e));
                    LOGGER.debug((Object)"adding TagReportData to tagReportDataList ");
                }
            }
            root.removeChildren("TagReportData", ns);
            this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
            tempList = root.getChildren("RFSurveyReportData", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"RO_ACCESS_REPORT misses optional parameter of type rFSurveyReportDataList");
            } else {
                for (Element e : tempList) {
                    this.rFSurveyReportDataList.add(new RFSurveyReportData(e));
                    LOGGER.debug((Object)"adding RFSurveyReportData to rFSurveyReportDataList ");
                }
            }
            root.removeChildren("RFSurveyReportData", ns);
            this.customList = new LinkedList<Custom>();
            tempList = root.getChildren("Custom", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"RO_ACCESS_REPORT misses optional parameter of type customList");
            } else {
                for (Element e : tempList) {
                    this.customList.add(new Custom(e));
                    LOGGER.debug((Object)"adding Custom to customList ");
                }
            }
            root.removeChildren("Custom", ns);
            if (root.getChildren().size() > 0) {
                String message = "RO_ACCESS_REPORT has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setTagReportDataList(List<TagReportData> tagReportDataList) {
        this.tagReportDataList = tagReportDataList;
    }

    public void setRFSurveyReportDataList(List<RFSurveyReportData> rFSurveyReportDataList) {
        this.rFSurveyReportDataList = rFSurveyReportDataList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<TagReportData> getTagReportDataList() {
        return this.tagReportDataList;
    }

    public List<RFSurveyReportData> getRFSurveyReportDataList() {
        return this.rFSurveyReportDataList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToTagReportDataList(TagReportData tagReportData) {
        if (this.tagReportDataList == null) {
            this.tagReportDataList = new LinkedList<TagReportData>();
        }
        this.tagReportDataList.add(tagReportData);
    }

    public void addToRFSurveyReportDataList(RFSurveyReportData rFSurveyReportData) {
        if (this.rFSurveyReportDataList == null) {
            this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
        }
        this.rFSurveyReportDataList.add(rFSurveyReportData);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "RO_ACCESS_REPORT";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

