/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.AccessReportSpec;
import org.llrp.ltk.generated.parameters.AntennaConfiguration;
import org.llrp.ltk.generated.parameters.AntennaProperties;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.EventsAndReports;
import org.llrp.ltk.generated.parameters.GPIPortCurrentState;
import org.llrp.ltk.generated.parameters.GPOWriteData;
import org.llrp.ltk.generated.parameters.KeepaliveSpec;
import org.llrp.ltk.generated.parameters.ROReportSpec;
import org.llrp.ltk.generated.parameters.ReaderEventNotificationSpec;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SET_READER_CONFIG
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(3);
    private static final Logger LOGGER = Logger.getLogger(SET_READER_CONFIG.class);
    public static final String RESPONSETYPE = "SET_READER_CONFIG_RESPONSE";
    protected Bit resetToFactoryDefault;
    protected BitList reserved0 = new BitList(7);
    protected ReaderEventNotificationSpec readerEventNotificationSpec;
    protected List<AntennaProperties> antennaPropertiesList = new LinkedList<AntennaProperties>();
    protected List<AntennaConfiguration> antennaConfigurationList = new LinkedList<AntennaConfiguration>();
    protected ROReportSpec rOReportSpec;
    protected AccessReportSpec accessReportSpec;
    protected KeepaliveSpec keepaliveSpec;
    protected List<GPOWriteData> gPOWriteDataList = new LinkedList<GPOWriteData>();
    protected List<GPIPortCurrentState> gPIPortCurrentStateList = new LinkedList<GPIPortCurrentState>();
    protected EventsAndReports eventsAndReports;
    protected List<Custom> customList = new LinkedList<Custom>();

    public SET_READER_CONFIG() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public SET_READER_CONFIG(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list.toByteArray());
    }

    public SET_READER_CONFIG(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public SET_READER_CONFIG(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.resetToFactoryDefault == null) {
            LOGGER.warn((Object)" resetToFactoryDefault not set");
            throw new InvalidLLRPMessageException(" resetToFactoryDefault not set  for Parameter of Type SET_READER_CONFIG");
        }
        resultBits.append(this.resetToFactoryDefault.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.readerEventNotificationSpec == null) {
            LOGGER.info((Object)" readerEventNotificationSpec not set");
        } else {
            resultBits.append(this.readerEventNotificationSpec.encodeBinary());
        }
        if (this.antennaPropertiesList == null) {
            LOGGER.info((Object)" antennaPropertiesList not set");
        } else {
            for (AntennaProperties antennaProperties : this.antennaPropertiesList) {
                resultBits.append(antennaProperties.encodeBinary());
            }
        }
        if (this.antennaConfigurationList == null) {
            LOGGER.info((Object)" antennaConfigurationList not set");
        } else {
            for (AntennaConfiguration antennaConfiguration : this.antennaConfigurationList) {
                resultBits.append(antennaConfiguration.encodeBinary());
            }
        }
        if (this.rOReportSpec == null) {
            LOGGER.info((Object)" rOReportSpec not set");
        } else {
            resultBits.append(this.rOReportSpec.encodeBinary());
        }
        if (this.accessReportSpec == null) {
            LOGGER.info((Object)" accessReportSpec not set");
        } else {
            resultBits.append(this.accessReportSpec.encodeBinary());
        }
        if (this.keepaliveSpec == null) {
            LOGGER.info((Object)" keepaliveSpec not set");
        } else {
            resultBits.append(this.keepaliveSpec.encodeBinary());
        }
        if (this.gPOWriteDataList == null) {
            LOGGER.info((Object)" gPOWriteDataList not set");
        } else {
            for (GPOWriteData gPOWriteData : this.gPOWriteDataList) {
                resultBits.append(gPOWriteData.encodeBinary());
            }
        }
        if (this.gPIPortCurrentStateList == null) {
            LOGGER.info((Object)" gPIPortCurrentStateList not set");
        } else {
            for (GPIPortCurrentState gPIPortCurrentState : this.gPIPortCurrentStateList) {
                resultBits.append(gPIPortCurrentState.encodeBinary());
            }
        }
        if (this.eventsAndReports == null) {
            LOGGER.info((Object)" eventsAndReports not set");
        } else {
            resultBits.append(this.eventsAndReports.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("SET_READER_CONFIG", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.resetToFactoryDefault == null) {
                LOGGER.warn((Object)" resetToFactoryDefault not set");
                throw new MissingParameterException(" resetToFactoryDefault not set");
            }
            root.addContent(this.resetToFactoryDefault.encodeXML("ResetToFactoryDefault", ns));
            if (this.readerEventNotificationSpec == null) {
                LOGGER.info((Object)"readerEventNotificationSpec not set");
            } else {
                root.addContent(this.readerEventNotificationSpec.encodeXML(this.readerEventNotificationSpec.getClass().getSimpleName(), ns));
            }
            if (this.antennaPropertiesList == null) {
                LOGGER.info((Object)"antennaPropertiesList not set");
            } else {
                for (AntennaProperties antennaProperties : this.antennaPropertiesList) {
                    root.addContent(antennaProperties.encodeXML(antennaProperties.getClass().getName().replaceAll(antennaProperties.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            if (this.antennaConfigurationList == null) {
                LOGGER.info((Object)"antennaConfigurationList not set");
            } else {
                for (AntennaConfiguration antennaConfiguration : this.antennaConfigurationList) {
                    root.addContent(antennaConfiguration.encodeXML(antennaConfiguration.getClass().getName().replaceAll(antennaConfiguration.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            if (this.rOReportSpec == null) {
                LOGGER.info((Object)"rOReportSpec not set");
            } else {
                root.addContent(this.rOReportSpec.encodeXML(this.rOReportSpec.getClass().getSimpleName(), ns));
            }
            if (this.accessReportSpec == null) {
                LOGGER.info((Object)"accessReportSpec not set");
            } else {
                root.addContent(this.accessReportSpec.encodeXML(this.accessReportSpec.getClass().getSimpleName(), ns));
            }
            if (this.keepaliveSpec == null) {
                LOGGER.info((Object)"keepaliveSpec not set");
            } else {
                root.addContent(this.keepaliveSpec.encodeXML(this.keepaliveSpec.getClass().getSimpleName(), ns));
            }
            if (this.gPOWriteDataList == null) {
                LOGGER.info((Object)"gPOWriteDataList not set");
            } else {
                for (GPOWriteData gPOWriteData : this.gPOWriteDataList) {
                    root.addContent(gPOWriteData.encodeXML(gPOWriteData.getClass().getName().replaceAll(gPOWriteData.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            if (this.gPIPortCurrentStateList == null) {
                LOGGER.info((Object)"gPIPortCurrentStateList not set");
            } else {
                for (GPIPortCurrentState gPIPortCurrentState : this.gPIPortCurrentStateList) {
                    root.addContent(gPIPortCurrentState.encodeXML(gPIPortCurrentState.getClass().getName().replaceAll(gPIPortCurrentState.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            if (this.eventsAndReports == null) {
                LOGGER.info((Object)"eventsAndReports not set");
            } else {
                root.addContent(this.eventsAndReports.encodeXML(this.eventsAndReports.getClass().getSimpleName(), ns));
            }
            if (this.customList == null) {
                LOGGER.info((Object)"customList not set");
            } else {
                for (Custom custom : this.customList) {
                    root.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        this.resetToFactoryDefault = new Bit(binary.subList(position, Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type ReaderEventNotificationSpec");
        }
        if (binary.get(position)) {
            SET_READER_CONFIG sET_READER_CONFIG = this;
            tempLength = sET_READER_CONFIG.readerEventNotificationSpec.length();
        }
        if (type != null && type.equals(ReaderEventNotificationSpec.TYPENUM)) {
            this.readerEventNotificationSpec = new ReaderEventNotificationSpec(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" readerEventNotificationSpec is instantiated with ReaderEventNotificationSpec with length" + tempLength));
        } else {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type ReaderEventNotificationSpec");
        }
        this.antennaPropertiesList = new LinkedList<AntennaProperties>();
        LOGGER.debug((Object)"decoding parameter antennaPropertiesList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(AntennaProperties.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = AntennaProperties.length();
                }
                this.antennaPropertiesList.add(new AntennaProperties(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding AntennaProperties to antennaPropertiesList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.antennaPropertiesList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional antennaPropertiesList");
        }
        this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
        LOGGER.debug((Object)"decoding parameter antennaConfigurationList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(AntennaConfiguration.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = AntennaConfiguration.length();
                }
                this.antennaConfigurationList.add(new AntennaConfiguration(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding AntennaConfiguration to antennaConfigurationList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.antennaConfigurationList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional antennaConfigurationList");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type ROReportSpec");
        }
        if (binary.get(position)) {
            SET_READER_CONFIG sET_READER_CONFIG = this;
            tempLength = sET_READER_CONFIG.rOReportSpec.length();
        }
        if (type != null && type.equals(ROReportSpec.TYPENUM)) {
            this.rOReportSpec = new ROReportSpec(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" rOReportSpec is instantiated with ROReportSpec with length" + tempLength));
        } else {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type ROReportSpec");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type AccessReportSpec");
        }
        if (binary.get(position)) {
            SET_READER_CONFIG sET_READER_CONFIG = this;
            tempLength = sET_READER_CONFIG.accessReportSpec.length();
        }
        if (type != null && type.equals(AccessReportSpec.TYPENUM)) {
            this.accessReportSpec = new AccessReportSpec(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" accessReportSpec is instantiated with AccessReportSpec with length" + tempLength));
        } else {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type AccessReportSpec");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type KeepaliveSpec");
        }
        if (binary.get(position)) {
            SET_READER_CONFIG sET_READER_CONFIG = this;
            tempLength = sET_READER_CONFIG.keepaliveSpec.length();
        }
        if (type != null && type.equals(KeepaliveSpec.TYPENUM)) {
            this.keepaliveSpec = new KeepaliveSpec(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" keepaliveSpec is instantiated with KeepaliveSpec with length" + tempLength));
        } else {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type KeepaliveSpec");
        }
        this.gPOWriteDataList = new LinkedList<GPOWriteData>();
        LOGGER.debug((Object)"decoding parameter gPOWriteDataList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(GPOWriteData.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = GPOWriteData.length();
                }
                this.gPOWriteDataList.add(new GPOWriteData(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding GPOWriteData to gPOWriteDataList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.gPOWriteDataList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional gPOWriteDataList");
        }
        this.gPIPortCurrentStateList = new LinkedList<GPIPortCurrentState>();
        LOGGER.debug((Object)"decoding parameter gPIPortCurrentStateList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(GPIPortCurrentState.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = GPIPortCurrentState.length();
                }
                this.gPIPortCurrentStateList.add(new GPIPortCurrentState(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding GPIPortCurrentState to gPIPortCurrentStateList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.gPIPortCurrentStateList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional gPIPortCurrentStateList");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type EventsAndReports");
        }
        if (binary.get(position)) {
            SET_READER_CONFIG sET_READER_CONFIG = this;
            tempLength = sET_READER_CONFIG.eventsAndReports.length();
        }
        if (type != null && type.equals(EventsAndReports.TYPENUM)) {
            this.eventsAndReports = new EventsAndReports(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" eventsAndReports is instantiated with EventsAndReports with length" + tempLength));
        } else {
            LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type EventsAndReports");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            List tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID"));
            temp = root.getChild("ResetToFactoryDefault", root.getNamespace());
            if (temp == null) {
                LOGGER.warn((Object)("Element resetToFactoryDefault not provided in xml as child of " + root.getName()));
                throw new MissingParameterException("Element resetToFactoryDefault not provided");
            }
            this.resetToFactoryDefault = new Bit(temp);
            root.removeChild("ResetToFactoryDefault", root.getNamespace());
            temp = root.getChild("ReaderEventNotificationSpec", ns);
            if (temp != null) {
                this.readerEventNotificationSpec = new ReaderEventNotificationSpec(temp);
                LOGGER.info((Object)"setting parameter readerEventNotificationSpec for parameter SET_READER_CONFIG");
            } else {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type readerEventNotificationSpec");
            }
            root.removeChild("ReaderEventNotificationSpec", ns);
            this.antennaPropertiesList = new LinkedList<AntennaProperties>();
            tempList = root.getChildren("AntennaProperties", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type antennaPropertiesList");
            } else {
                for (Element e : tempList) {
                    this.antennaPropertiesList.add(new AntennaProperties(e));
                    LOGGER.debug((Object)"adding AntennaProperties to antennaPropertiesList ");
                }
            }
            root.removeChildren("AntennaProperties", ns);
            this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
            tempList = root.getChildren("AntennaConfiguration", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type antennaConfigurationList");
            } else {
                for (Element e : tempList) {
                    this.antennaConfigurationList.add(new AntennaConfiguration(e));
                    LOGGER.debug((Object)"adding AntennaConfiguration to antennaConfigurationList ");
                }
            }
            root.removeChildren("AntennaConfiguration", ns);
            temp = root.getChild("ROReportSpec", ns);
            if (temp != null) {
                this.rOReportSpec = new ROReportSpec(temp);
                LOGGER.info((Object)"setting parameter rOReportSpec for parameter SET_READER_CONFIG");
            } else {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type rOReportSpec");
            }
            root.removeChild("ROReportSpec", ns);
            temp = root.getChild("AccessReportSpec", ns);
            if (temp != null) {
                this.accessReportSpec = new AccessReportSpec(temp);
                LOGGER.info((Object)"setting parameter accessReportSpec for parameter SET_READER_CONFIG");
            } else {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type accessReportSpec");
            }
            root.removeChild("AccessReportSpec", ns);
            temp = root.getChild("KeepaliveSpec", ns);
            if (temp != null) {
                this.keepaliveSpec = new KeepaliveSpec(temp);
                LOGGER.info((Object)"setting parameter keepaliveSpec for parameter SET_READER_CONFIG");
            } else {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type keepaliveSpec");
            }
            root.removeChild("KeepaliveSpec", ns);
            this.gPOWriteDataList = new LinkedList<GPOWriteData>();
            tempList = root.getChildren("GPOWriteData", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type gPOWriteDataList");
            } else {
                for (Element e : tempList) {
                    this.gPOWriteDataList.add(new GPOWriteData(e));
                    LOGGER.debug((Object)"adding GPOWriteData to gPOWriteDataList ");
                }
            }
            root.removeChildren("GPOWriteData", ns);
            this.gPIPortCurrentStateList = new LinkedList<GPIPortCurrentState>();
            tempList = root.getChildren("GPIPortCurrentState", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type gPIPortCurrentStateList");
            } else {
                for (Element e : tempList) {
                    this.gPIPortCurrentStateList.add(new GPIPortCurrentState(e));
                    LOGGER.debug((Object)"adding GPIPortCurrentState to gPIPortCurrentStateList ");
                }
            }
            root.removeChildren("GPIPortCurrentState", ns);
            temp = root.getChild("EventsAndReports", ns);
            if (temp != null) {
                this.eventsAndReports = new EventsAndReports(temp);
                LOGGER.info((Object)"setting parameter eventsAndReports for parameter SET_READER_CONFIG");
            } else {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type eventsAndReports");
            }
            root.removeChild("EventsAndReports", ns);
            this.customList = new LinkedList<Custom>();
            tempList = root.getChildren("Custom", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.info((Object)"SET_READER_CONFIG misses optional parameter of type customList");
            } else {
                for (Element e : tempList) {
                    this.customList.add(new Custom(e));
                    LOGGER.debug((Object)"adding Custom to customList ");
                }
            }
            root.removeChildren("Custom", ns);
            if (root.getChildren().size() > 0) {
                String message = "SET_READER_CONFIG has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setResetToFactoryDefault(Bit resetToFactoryDefault) {
        this.resetToFactoryDefault = resetToFactoryDefault;
    }

    public void setReaderEventNotificationSpec(ReaderEventNotificationSpec readerEventNotificationSpec) {
        this.readerEventNotificationSpec = readerEventNotificationSpec;
    }

    public void setAntennaPropertiesList(List<AntennaProperties> antennaPropertiesList) {
        this.antennaPropertiesList = antennaPropertiesList;
    }

    public void setAntennaConfigurationList(List<AntennaConfiguration> antennaConfigurationList) {
        this.antennaConfigurationList = antennaConfigurationList;
    }

    public void setROReportSpec(ROReportSpec rOReportSpec) {
        this.rOReportSpec = rOReportSpec;
    }

    public void setAccessReportSpec(AccessReportSpec accessReportSpec) {
        this.accessReportSpec = accessReportSpec;
    }

    public void setKeepaliveSpec(KeepaliveSpec keepaliveSpec) {
        this.keepaliveSpec = keepaliveSpec;
    }

    public void setGPOWriteDataList(List<GPOWriteData> gPOWriteDataList) {
        this.gPOWriteDataList = gPOWriteDataList;
    }

    public void setGPIPortCurrentStateList(List<GPIPortCurrentState> gPIPortCurrentStateList) {
        this.gPIPortCurrentStateList = gPIPortCurrentStateList;
    }

    public void setEventsAndReports(EventsAndReports eventsAndReports) {
        this.eventsAndReports = eventsAndReports;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public Bit getResetToFactoryDefault() {
        return this.resetToFactoryDefault;
    }

    public ReaderEventNotificationSpec getReaderEventNotificationSpec() {
        return this.readerEventNotificationSpec;
    }

    public List<AntennaProperties> getAntennaPropertiesList() {
        return this.antennaPropertiesList;
    }

    public List<AntennaConfiguration> getAntennaConfigurationList() {
        return this.antennaConfigurationList;
    }

    public ROReportSpec getROReportSpec() {
        return this.rOReportSpec;
    }

    public AccessReportSpec getAccessReportSpec() {
        return this.accessReportSpec;
    }

    public KeepaliveSpec getKeepaliveSpec() {
        return this.keepaliveSpec;
    }

    public List<GPOWriteData> getGPOWriteDataList() {
        return this.gPOWriteDataList;
    }

    public List<GPIPortCurrentState> getGPIPortCurrentStateList() {
        return this.gPIPortCurrentStateList;
    }

    public EventsAndReports getEventsAndReports() {
        return this.eventsAndReports;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToAntennaPropertiesList(AntennaProperties antennaProperties) {
        if (this.antennaPropertiesList == null) {
            this.antennaPropertiesList = new LinkedList<AntennaProperties>();
        }
        this.antennaPropertiesList.add(antennaProperties);
    }

    public void addToAntennaConfigurationList(AntennaConfiguration antennaConfiguration) {
        if (this.antennaConfigurationList == null) {
            this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
        }
        this.antennaConfigurationList.add(antennaConfiguration);
    }

    public void addToGPOWriteDataList(GPOWriteData gPOWriteData) {
        if (this.gPOWriteDataList == null) {
            this.gPOWriteDataList = new LinkedList<GPOWriteData>();
        }
        this.gPOWriteDataList.add(gPOWriteData);
    }

    public void addToGPIPortCurrentStateList(GPIPortCurrentState gPIPortCurrentState) {
        if (this.gPIPortCurrentStateList == null) {
            this.gPIPortCurrentStateList = new LinkedList<GPIPortCurrentState>();
        }
        this.gPIPortCurrentStateList.add(gPIPortCurrentState);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "SET_READER_CONFIG";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

