/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.interfaces.AirProtocolTagSpec;
import org.llrp.ltk.generated.parameters.C1G2BlockErase;
import org.llrp.ltk.generated.parameters.C1G2BlockWrite;
import org.llrp.ltk.generated.parameters.C1G2Kill;
import org.llrp.ltk.generated.parameters.C1G2Lock;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.C1G2TagSpec;
import org.llrp.ltk.generated.parameters.C1G2Write;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessCommand
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(209);
    private static final Logger LOGGER = Logger.getLogger(AccessCommand.class);
    protected AirProtocolTagSpec airProtocolTagSpec;
    protected List<AccessCommandOpSpec> accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public AccessCommand() {
    }

    public AccessCommand(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AccessCommand(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.airProtocolTagSpec == null) {
            LOGGER.warn((Object)" airProtocolTagSpec not set");
            throw new MissingParameterException(" airProtocolTagSpec not set");
        }
        resultBits.append(this.airProtocolTagSpec.encodeBinary());
        if (this.accessCommandOpSpecList == null) {
            LOGGER.warn((Object)" accessCommandOpSpecList not set");
            throw new MissingParameterException(" accessCommandOpSpecList not set");
        }
        for (AccessCommandOpSpec accessCommandOpSpec : this.accessCommandOpSpecList) {
            resultBits.append(accessCommandOpSpec.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.airProtocolTagSpec == null) {
            LOGGER.info((Object)"airProtocolTagSpec not set");
            throw new MissingParameterException("airProtocolTagSpec not set");
        }
        element.addContent(this.airProtocolTagSpec.encodeXML(this.airProtocolTagSpec.getClass().getSimpleName(), ns));
        if (this.accessCommandOpSpecList == null) {
            LOGGER.warn((Object)" accessCommandOpSpecList not set");
            throw new MissingParameterException("  accessCommandOpSpecList not set");
        }
        for (AccessCommandOpSpec accessCommandOpSpec : this.accessCommandOpSpecList) {
            element.addContent(accessCommandOpSpec.encodeXML(accessCommandOpSpec.getClass().getName().replaceAll(accessCommandOpSpec.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"AccessCommand misses non optional parameter of type AirProtocolTagSpec");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AirProtocolTagSpec");
        }
        boolean found = false;
        LOGGER.debug((Object)"decoding choice type AirProtocolTagSpec ");
        if (binary.get(position)) {
            tempLength = C1G2TagSpec.length();
        }
        if (type != null && type.equals(C1G2TagSpec.TYPENUM)) {
            this.airProtocolTagSpec = new C1G2TagSpec(binary.subList(position, tempLength));
            LOGGER.debug((Object)(" airProtocolTagSpec instatiated to C1G2TagSpec with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (!found) {
            LOGGER.warn((Object)"encoded message misses non optional parameter airProtocolTagSpec");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AirProtocolTagSpec");
        }
        this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        LOGGER.debug((Object)"decoding parameter accessCommandOpSpecList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2Read.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Read.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Read(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2Read to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (type != null && type.equals(C1G2Write.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Write.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Write(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2Write to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (type != null && type.equals(C1G2Kill.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Kill.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Kill(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2Kill to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (type != null && type.equals(C1G2Lock.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Lock.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Lock(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2Lock to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (type != null && type.equals(C1G2BlockErase.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockErase.length();
                }
                this.accessCommandOpSpecList.add(new C1G2BlockErase(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2BlockErase to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (type != null && type.equals(C1G2BlockWrite.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockWrite.length();
                }
                this.accessCommandOpSpecList.add(new C1G2BlockWrite(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2BlockWrite to accessCommandOpSpecList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.accessCommandOpSpecList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional accessCommandOpSpecList");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AccessCommandOpSpec");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        boolean found = false;
        LOGGER.debug((Object)"decoding choice type AirProtocolTagSpec ");
        temp = element.getChild("C1G2TagSpec", ns);
        if (temp != null) {
            this.airProtocolTagSpec = new C1G2TagSpec(temp);
            LOGGER.debug((Object)" airProtocolTagSpec instatiated to C1G2TagSpec with");
            found = true;
        }
        element.removeChild("C1G2TagSpec", ns);
        if (!found) {
            LOGGER.info((Object)"AccessCommand misses optional parameter of type airProtocolTagSpecList");
        }
        this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        tempList = element.getChildren("C1G2Read", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2Read(e));
            LOGGER.debug((Object)"adding C1G2Read to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2Read", ns);
        tempList = element.getChildren("C1G2Write", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2Write(e));
            LOGGER.debug((Object)"adding C1G2Write to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2Write", ns);
        tempList = element.getChildren("C1G2Kill", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2Kill(e));
            LOGGER.debug((Object)"adding C1G2Kill to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2Kill", ns);
        tempList = element.getChildren("C1G2Lock", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2Lock(e));
            LOGGER.debug((Object)"adding C1G2Lock to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2Lock", ns);
        tempList = element.getChildren("C1G2BlockErase", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2BlockErase(e));
            LOGGER.debug((Object)"adding C1G2BlockErase to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2BlockErase", ns);
        tempList = element.getChildren("C1G2BlockWrite", ns);
        for (Element e : tempList) {
            this.accessCommandOpSpecList.add(new C1G2BlockWrite(e));
            LOGGER.debug((Object)"adding C1G2BlockWrite to accessCommandOpSpecList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2BlockWrite", ns);
        if (!atLeastOnce) {
            LOGGER.warn((Object)"AccessCommand misses non optional parameter of type accessCommandOpSpecList");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type accessCommandOpSpecList");
        }
        atLeastOnce = false;
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"AccessCommand misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "AccessCommand has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAirProtocolTagSpec(AirProtocolTagSpec airProtocolTagSpec) {
        this.airProtocolTagSpec = airProtocolTagSpec;
    }

    public void setAccessCommandOpSpecList(List<AccessCommandOpSpec> accessCommandOpSpecList) {
        this.accessCommandOpSpecList = accessCommandOpSpecList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public AirProtocolTagSpec getAirProtocolTagSpec() {
        return this.airProtocolTagSpec;
    }

    public List<AccessCommandOpSpec> getAccessCommandOpSpecList() {
        return this.accessCommandOpSpecList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToAccessCommandOpSpecList(AccessCommandOpSpec accessCommandOpSpec) {
        if (this.accessCommandOpSpecList == null) {
            this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        }
        this.accessCommandOpSpecList.add(accessCommandOpSpec);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AccessCommand";
    }

    public String toString() {
        String result = "AccessCommand: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

