/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolInventoryCommandSettings;
import org.llrp.ltk.generated.parameters.C1G2InventoryCommand;
import org.llrp.ltk.generated.parameters.RFReceiver;
import org.llrp.ltk.generated.parameters.RFTransmitter;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntennaConfiguration
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(222);
    private static final Logger LOGGER = Logger.getLogger(AntennaConfiguration.class);
    protected UnsignedShort antennaID;
    protected RFReceiver rFReceiver;
    protected RFTransmitter rFTransmitter;
    protected List<AirProtocolInventoryCommandSettings> airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();

    public AntennaConfiguration() {
    }

    public AntennaConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AntennaConfiguration(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type AntennaConfiguration");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.rFReceiver == null) {
            LOGGER.info((Object)" rFReceiver not set");
        } else {
            resultBits.append(this.rFReceiver.encodeBinary());
        }
        if (this.rFTransmitter == null) {
            LOGGER.info((Object)" rFTransmitter not set");
        } else {
            resultBits.append(this.rFTransmitter.encodeBinary());
        }
        if (this.airProtocolInventoryCommandSettingsList == null) {
            LOGGER.info((Object)" airProtocolInventoryCommandSettingsList not set");
        } else {
            for (AirProtocolInventoryCommandSettings field : this.airProtocolInventoryCommandSettingsList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.rFReceiver == null) {
            LOGGER.info((Object)"rFReceiver not set");
        } else {
            element.addContent(this.rFReceiver.encodeXML(this.rFReceiver.getClass().getSimpleName(), ns));
        }
        if (this.rFTransmitter == null) {
            LOGGER.info((Object)"rFTransmitter not set");
        } else {
            element.addContent(this.rFTransmitter.encodeXML(this.rFTransmitter.getClass().getSimpleName(), ns));
        }
        if (this.airProtocolInventoryCommandSettingsList == null) {
            LOGGER.info((Object)"airProtocolInventoryCommandSettingsList not set");
        } else {
            for (AirProtocolInventoryCommandSettings field : this.airProtocolInventoryCommandSettingsList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.antennaID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        position += UnsignedShort.length();
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type RFReceiver");
        }
        if (binary.get(position)) {
            AntennaConfiguration antennaConfiguration = this;
            tempLength = antennaConfiguration.rFReceiver.length();
        }
        if (type != null && type.equals(RFReceiver.TYPENUM)) {
            this.rFReceiver = new RFReceiver(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" rFReceiver is instantiated with RFReceiver with length" + tempLength));
        } else {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type RFReceiver");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type RFTransmitter");
        }
        if (binary.get(position)) {
            AntennaConfiguration antennaConfiguration = this;
            tempLength = antennaConfiguration.rFTransmitter.length();
        }
        if (type != null && type.equals(RFTransmitter.TYPENUM)) {
            this.rFTransmitter = new RFTransmitter(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" rFTransmitter is instantiated with RFTransmitter with length" + tempLength));
        } else {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type RFTransmitter");
        }
        this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        LOGGER.debug((Object)"decoding parameter airProtocolInventoryCommandSettingsList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2InventoryCommand.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2InventoryCommand.length();
                }
                this.airProtocolInventoryCommandSettingsList.add(new C1G2InventoryCommand(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2InventoryCommand to airProtocolInventoryCommandSettingsList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.airProtocolInventoryCommandSettingsList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional airProtocolInventoryCommandSettingsList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("RFReceiver", ns);
        if (temp != null) {
            this.rFReceiver = new RFReceiver(temp);
            LOGGER.info((Object)"setting parameter rFReceiver for parameter AntennaConfiguration");
        }
        if (temp == null) {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type rFReceiver");
        }
        element.removeChild("RFReceiver", ns);
        temp = element.getChild("RFTransmitter", ns);
        if (temp != null) {
            this.rFTransmitter = new RFTransmitter(temp);
            LOGGER.info((Object)"setting parameter rFTransmitter for parameter AntennaConfiguration");
        }
        if (temp == null) {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type rFTransmitter");
        }
        element.removeChild("RFTransmitter", ns);
        this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        tempList = element.getChildren("C1G2InventoryCommand", ns);
        for (Element e : tempList) {
            this.airProtocolInventoryCommandSettingsList.add(new C1G2InventoryCommand(e));
            LOGGER.debug((Object)"adding C1G2InventoryCommand to airProtocolInventoryCommandSettingsList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2InventoryCommand", ns);
        if (!atLeastOnce) {
            LOGGER.info((Object)"AntennaConfiguration misses optional parameter of type airProtocolInventoryCommandSettingsList");
        }
        atLeastOnce = false;
        if (element.getChildren().size() > 0) {
            String message = "AntennaConfiguration has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setRFReceiver(RFReceiver rFReceiver) {
        this.rFReceiver = rFReceiver;
    }

    public void setRFTransmitter(RFTransmitter rFTransmitter) {
        this.rFTransmitter = rFTransmitter;
    }

    public void setAirProtocolInventoryCommandSettingsList(List<AirProtocolInventoryCommandSettings> airProtocolInventoryCommandSettingsList) {
        this.airProtocolInventoryCommandSettingsList = airProtocolInventoryCommandSettingsList;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public RFReceiver getRFReceiver() {
        return this.rFReceiver;
    }

    public RFTransmitter getRFTransmitter() {
        return this.rFTransmitter;
    }

    public List<AirProtocolInventoryCommandSettings> getAirProtocolInventoryCommandSettingsList() {
        return this.airProtocolInventoryCommandSettingsList;
    }

    public void addToAirProtocolInventoryCommandSettingsList(AirProtocolInventoryCommandSettings airProtocolInventoryCommandSettings) {
        if (this.airProtocolInventoryCommandSettingsList == null) {
            this.airProtocolInventoryCommandSettingsList = new LinkedList<AirProtocolInventoryCommandSettings>();
        }
        this.airProtocolInventoryCommandSettingsList.add(airProtocolInventoryCommandSettings);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AntennaConfiguration";
    }

    public String toString() {
        String result = "AntennaConfiguration: ";
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

