/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class AntennaProperties
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(221);
    private static final Logger LOGGER = Logger.getLogger(AntennaProperties.class);
    protected Bit antennaConnected;
    protected BitList reserved0 = new BitList(7);
    protected UnsignedShort antennaID;
    protected SignedShort antennaGain;

    public AntennaProperties() {
    }

    public AntennaProperties(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AntennaProperties(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaConnected == null) {
            LOGGER.warn((Object)" antennaConnected not set");
            throw new MissingParameterException(" antennaConnected not set  for Parameter of Type AntennaProperties");
        }
        resultBits.append(this.antennaConnected.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type AntennaProperties");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.antennaGain == null) {
            LOGGER.warn((Object)" antennaGain not set");
            throw new MissingParameterException(" antennaGain not set  for Parameter of Type AntennaProperties");
        }
        resultBits.append(this.antennaGain.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.antennaConnected == null) {
            LOGGER.warn((Object)" antennaConnected not set");
            throw new MissingParameterException(" antennaConnected not set");
        }
        element.addContent(this.antennaConnected.encodeXML("AntennaConnected", ns));
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.antennaGain == null) {
            LOGGER.warn((Object)" antennaGain not set");
            throw new MissingParameterException(" antennaGain not set");
        }
        element.addContent(this.antennaGain.encodeXML("AntennaGain", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.antennaConnected = new Bit(binary.subList(position, Bit.length()));
        position += Bit.length();
        this.antennaID = new UnsignedShort(binary.subList(position += this.reserved0.length(), UnsignedShort.length()));
        this.antennaGain = new SignedShort(binary.subList(position += UnsignedShort.length(), SignedShort.length()));
        position += SignedShort.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaConnected", ns);
        if (temp != null) {
            this.antennaConnected = new Bit(temp);
        }
        element.removeChild("AntennaConnected", ns);
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("AntennaGain", ns);
        if (temp != null) {
            this.antennaGain = new SignedShort(temp);
        }
        element.removeChild("AntennaGain", ns);
        if (element.getChildren().size() > 0) {
            String message = "AntennaProperties has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaConnected(Bit antennaConnected) {
        this.antennaConnected = antennaConnected;
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setAntennaGain(SignedShort antennaGain) {
        this.antennaGain = antennaGain;
    }

    public Bit getAntennaConnected() {
        return this.antennaConnected;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public SignedShort getAntennaGain() {
        return this.antennaGain;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "AntennaProperties";
    }

    public String toString() {
        String result = "AntennaProperties: ";
        result = result + ", antennaConnected: ";
        result = result + this.antennaConnected;
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result + ", antennaGain: ";
        result = result + this.antennaGain;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

