/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class C1G2BlockWrite
extends TLVParameter
implements AccessCommandOpSpec {
    public static final SignedShort TYPENUM = new SignedShort(347);
    private static final Logger LOGGER = Logger.getLogger(C1G2BlockWrite.class);
    protected UnsignedShort opSpecID;
    protected UnsignedInteger accessPassword;
    protected TwoBitField mB;
    protected BitList reserved0 = new BitList(6);
    protected UnsignedShort wordPointer;
    protected UnsignedShortArray_HEX writeData;

    public C1G2BlockWrite() {
    }

    public C1G2BlockWrite(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2BlockWrite(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set  for Parameter of Type C1G2BlockWrite");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.accessPassword == null) {
            LOGGER.warn((Object)" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set  for Parameter of Type C1G2BlockWrite");
        }
        resultBits.append(this.accessPassword.encodeBinary());
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set  for Parameter of Type C1G2BlockWrite");
        }
        resultBits.append(this.mB.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.wordPointer == null) {
            LOGGER.warn((Object)" wordPointer not set");
            throw new MissingParameterException(" wordPointer not set  for Parameter of Type C1G2BlockWrite");
        }
        resultBits.append(this.wordPointer.encodeBinary());
        if (this.writeData == null) {
            LOGGER.warn((Object)" writeData not set");
            throw new MissingParameterException(" writeData not set  for Parameter of Type C1G2BlockWrite");
        }
        resultBits.append(this.writeData.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.accessPassword == null) {
            LOGGER.warn((Object)" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set");
        }
        element.addContent(this.accessPassword.encodeXML("AccessPassword", ns));
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set");
        }
        element.addContent(this.mB.encodeXML("MB", ns));
        if (this.wordPointer == null) {
            LOGGER.warn((Object)" wordPointer not set");
            throw new MissingParameterException(" wordPointer not set");
        }
        element.addContent(this.wordPointer.encodeXML("WordPointer", ns));
        if (this.writeData == null) {
            LOGGER.warn((Object)" writeData not set");
            throw new MissingParameterException(" writeData not set");
        }
        element.addContent(this.writeData.encodeXML("WriteData", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.opSpecID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.accessPassword = new UnsignedInteger(binary.subList(position += UnsignedShort.length(), UnsignedInteger.length()));
        this.mB = new TwoBitField(binary.subList(position += UnsignedInteger.length(), TwoBitField.length()));
        position += TwoBitField.length();
        this.wordPointer = new UnsignedShort(binary.subList(position += this.reserved0.length(), UnsignedShort.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length())).toShort();
        tempLength = UnsignedShortArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.writeData = new UnsignedShortArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UnsignedShortArray_HEX with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for writeData ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        element.removeChild("OpSpecID", ns);
        temp = element.getChild("AccessPassword", ns);
        if (temp != null) {
            this.accessPassword = new UnsignedInteger(temp);
        }
        element.removeChild("AccessPassword", ns);
        temp = element.getChild("MB", ns);
        if (temp != null) {
            this.mB = new TwoBitField(temp);
        }
        element.removeChild("MB", ns);
        temp = element.getChild("WordPointer", ns);
        if (temp != null) {
            this.wordPointer = new UnsignedShort(temp);
        }
        element.removeChild("WordPointer", ns);
        temp = element.getChild("WriteData", ns);
        if (temp != null) {
            this.writeData = new UnsignedShortArray_HEX(temp);
        }
        element.removeChild("WriteData", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2BlockWrite has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setAccessPassword(UnsignedInteger accessPassword) {
        this.accessPassword = accessPassword;
    }

    public void setMB(TwoBitField mB) {
        this.mB = mB;
    }

    public void setWordPointer(UnsignedShort wordPointer) {
        this.wordPointer = wordPointer;
    }

    public void setWriteData(UnsignedShortArray_HEX writeData) {
        this.writeData = writeData;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedInteger getAccessPassword() {
        return this.accessPassword;
    }

    public TwoBitField getMB() {
        return this.mB;
    }

    public UnsignedShort getWordPointer() {
        return this.wordPointer;
    }

    public UnsignedShortArray_HEX getWriteData() {
        return this.writeData;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2BlockWrite";
    }

    public String toString() {
        String result = "C1G2BlockWrite: ";
        result = result + ", opSpecID: ";
        result = result + this.opSpecID;
        result = result + ", accessPassword: ";
        result = result + this.accessPassword;
        result = result + ", mB: ";
        result = result + this.mB;
        result = result + ", wordPointer: ";
        result = result + this.wordPointer;
        result = result + ", writeData: ";
        result = result + this.writeData;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

