/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolEPCMemorySelector;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;

public class C1G2EPCMemorySelector
extends TLVParameter
implements AirProtocolEPCMemorySelector {
    public static final SignedShort TYPENUM = new SignedShort(348);
    private static final Logger LOGGER = Logger.getLogger(C1G2EPCMemorySelector.class);
    protected Bit enableCRC;
    protected Bit enablePCBits;
    protected BitList reserved0 = new BitList(6);

    public C1G2EPCMemorySelector() {
    }

    public C1G2EPCMemorySelector(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2EPCMemorySelector(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.enableCRC == null) {
            LOGGER.warn((Object)" enableCRC not set");
            throw new MissingParameterException(" enableCRC not set  for Parameter of Type C1G2EPCMemorySelector");
        }
        resultBits.append(this.enableCRC.encodeBinary());
        if (this.enablePCBits == null) {
            LOGGER.warn((Object)" enablePCBits not set");
            throw new MissingParameterException(" enablePCBits not set  for Parameter of Type C1G2EPCMemorySelector");
        }
        resultBits.append(this.enablePCBits.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.enableCRC == null) {
            LOGGER.warn((Object)" enableCRC not set");
            throw new MissingParameterException(" enableCRC not set");
        }
        element.addContent(this.enableCRC.encodeXML("EnableCRC", ns));
        if (this.enablePCBits == null) {
            LOGGER.warn((Object)" enablePCBits not set");
            throw new MissingParameterException(" enablePCBits not set");
        }
        element.addContent(this.enablePCBits.encodeXML("EnablePCBits", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.enableCRC = new Bit(binary.subList(position, Bit.length()));
        this.enablePCBits = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EnableCRC", ns);
        if (temp != null) {
            this.enableCRC = new Bit(temp);
        }
        element.removeChild("EnableCRC", ns);
        temp = element.getChild("EnablePCBits", ns);
        if (temp != null) {
            this.enablePCBits = new Bit(temp);
        }
        element.removeChild("EnablePCBits", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2EPCMemorySelector has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEnableCRC(Bit enableCRC) {
        this.enableCRC = enableCRC;
    }

    public void setEnablePCBits(Bit enablePCBits) {
        this.enablePCBits = enablePCBits;
    }

    public Bit getEnableCRC() {
        return this.enableCRC;
    }

    public Bit getEnablePCBits() {
        return this.enablePCBits;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2EPCMemorySelector";
    }

    public String toString() {
        String result = "C1G2EPCMemorySelector: ";
        result = result + ", enableCRC: ";
        result = result + this.enableCRC;
        result = result + ", enablePCBits: ";
        result = result + this.enablePCBits;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

