/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolInventoryCommandSettings;
import org.llrp.ltk.generated.parameters.C1G2Filter;
import org.llrp.ltk.generated.parameters.C1G2RFControl;
import org.llrp.ltk.generated.parameters.C1G2SingulationControl;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C1G2InventoryCommand
extends TLVParameter
implements AirProtocolInventoryCommandSettings {
    public static final SignedShort TYPENUM = new SignedShort(330);
    private static final Logger LOGGER = Logger.getLogger(C1G2InventoryCommand.class);
    protected Bit tagInventoryStateAware;
    protected BitList reserved0 = new BitList(7);
    protected List<C1G2Filter> c1G2FilterList = new LinkedList<C1G2Filter>();
    protected C1G2RFControl c1G2RFControl;
    protected C1G2SingulationControl c1G2SingulationControl;
    protected List<Custom> customList = new LinkedList<Custom>();

    public C1G2InventoryCommand() {
    }

    public C1G2InventoryCommand(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2InventoryCommand(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.tagInventoryStateAware == null) {
            LOGGER.warn((Object)" tagInventoryStateAware not set");
            throw new MissingParameterException(" tagInventoryStateAware not set  for Parameter of Type C1G2InventoryCommand");
        }
        resultBits.append(this.tagInventoryStateAware.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.c1G2FilterList == null) {
            LOGGER.info((Object)" c1G2FilterList not set");
        } else {
            for (C1G2Filter c1G2Filter : this.c1G2FilterList) {
                resultBits.append(c1G2Filter.encodeBinary());
            }
        }
        if (this.c1G2RFControl == null) {
            LOGGER.info((Object)" c1G2RFControl not set");
        } else {
            resultBits.append(this.c1G2RFControl.encodeBinary());
        }
        if (this.c1G2SingulationControl == null) {
            LOGGER.info((Object)" c1G2SingulationControl not set");
        } else {
            resultBits.append(this.c1G2SingulationControl.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.tagInventoryStateAware == null) {
            LOGGER.warn((Object)" tagInventoryStateAware not set");
            throw new MissingParameterException(" tagInventoryStateAware not set");
        }
        element.addContent(this.tagInventoryStateAware.encodeXML("TagInventoryStateAware", ns));
        if (this.c1G2FilterList == null) {
            LOGGER.info((Object)"c1G2FilterList not set");
        } else {
            for (C1G2Filter c1G2Filter : this.c1G2FilterList) {
                element.addContent(c1G2Filter.encodeXML(c1G2Filter.getClass().getName().replaceAll(c1G2Filter.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.c1G2RFControl == null) {
            LOGGER.info((Object)"c1G2RFControl not set");
        } else {
            element.addContent(this.c1G2RFControl.encodeXML(this.c1G2RFControl.getClass().getSimpleName(), ns));
        }
        if (this.c1G2SingulationControl == null) {
            LOGGER.info((Object)"c1G2SingulationControl not set");
        } else {
            element.addContent(this.c1G2SingulationControl.encodeXML(this.c1G2SingulationControl.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort type;
        int position = 0;
        int tempLength = 0;
        this.tagInventoryStateAware = new Bit(binary.subList(position, Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
        this.c1G2FilterList = new LinkedList<C1G2Filter>();
        LOGGER.debug((Object)"decoding parameter c1G2FilterList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2Filter.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Filter.length();
                }
                this.c1G2FilterList.add(new C1G2Filter(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2Filter to c1G2FilterList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.c1G2FilterList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional c1G2FilterList");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type C1G2RFControl");
        }
        if (binary.get(position)) {
            C1G2InventoryCommand c1G2InventoryCommand = this;
            tempLength = c1G2InventoryCommand.c1G2RFControl.length();
        }
        if (type != null && type.equals(C1G2RFControl.TYPENUM)) {
            this.c1G2RFControl = new C1G2RFControl(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" c1G2RFControl is instantiated with C1G2RFControl with length" + tempLength));
        } else {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type C1G2RFControl");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type C1G2SingulationControl");
        }
        if (binary.get(position)) {
            C1G2InventoryCommand c1G2InventoryCommand = this;
            tempLength = c1G2InventoryCommand.c1G2SingulationControl.length();
        }
        if (type != null && type.equals(C1G2SingulationControl.TYPENUM)) {
            this.c1G2SingulationControl = new C1G2SingulationControl(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" c1G2SingulationControl is instantiated with C1G2SingulationControl with length" + tempLength));
        } else {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type C1G2SingulationControl");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("TagInventoryStateAware", ns);
        if (temp != null) {
            this.tagInventoryStateAware = new Bit(temp);
        }
        element.removeChild("TagInventoryStateAware", ns);
        this.c1G2FilterList = new LinkedList<C1G2Filter>();
        tempList = element.getChildren("C1G2Filter", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type c1G2FilterList");
        } else {
            for (Element e : tempList) {
                this.c1G2FilterList.add(new C1G2Filter(e));
                LOGGER.debug((Object)"adding C1G2Filter to c1G2FilterList ");
            }
        }
        element.removeChildren("C1G2Filter", ns);
        temp = element.getChild("C1G2RFControl", ns);
        if (temp != null) {
            this.c1G2RFControl = new C1G2RFControl(temp);
            LOGGER.info((Object)"setting parameter c1G2RFControl for parameter C1G2InventoryCommand");
        }
        if (temp == null) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type c1G2RFControl");
        }
        element.removeChild("C1G2RFControl", ns);
        temp = element.getChild("C1G2SingulationControl", ns);
        if (temp != null) {
            this.c1G2SingulationControl = new C1G2SingulationControl(temp);
            LOGGER.info((Object)"setting parameter c1G2SingulationControl for parameter C1G2InventoryCommand");
        }
        if (temp == null) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type c1G2SingulationControl");
        }
        element.removeChild("C1G2SingulationControl", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"C1G2InventoryCommand misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2InventoryCommand has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setTagInventoryStateAware(Bit tagInventoryStateAware) {
        this.tagInventoryStateAware = tagInventoryStateAware;
    }

    public void setC1G2FilterList(List<C1G2Filter> c1G2FilterList) {
        this.c1G2FilterList = c1G2FilterList;
    }

    public void setC1G2RFControl(C1G2RFControl c1G2RFControl) {
        this.c1G2RFControl = c1G2RFControl;
    }

    public void setC1G2SingulationControl(C1G2SingulationControl c1G2SingulationControl) {
        this.c1G2SingulationControl = c1G2SingulationControl;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public Bit getTagInventoryStateAware() {
        return this.tagInventoryStateAware;
    }

    public List<C1G2Filter> getC1G2FilterList() {
        return this.c1G2FilterList;
    }

    public C1G2RFControl getC1G2RFControl() {
        return this.c1G2RFControl;
    }

    public C1G2SingulationControl getC1G2SingulationControl() {
        return this.c1G2SingulationControl;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToC1G2FilterList(C1G2Filter c1G2Filter) {
        if (this.c1G2FilterList == null) {
            this.c1G2FilterList = new LinkedList<C1G2Filter>();
        }
        this.c1G2FilterList.add(c1G2Filter);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2InventoryCommand";
    }

    public String toString() {
        String result = "C1G2InventoryCommand: ";
        result = result + ", tagInventoryStateAware: ";
        result = result + this.tagInventoryStateAware;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

