/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolLLRPCapabilities;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2LLRPCapabilities
extends TLVParameter
implements AirProtocolLLRPCapabilities {
    public static final SignedShort TYPENUM = new SignedShort(327);
    private static final Logger LOGGER = Logger.getLogger(C1G2LLRPCapabilities.class);
    protected Bit canSupportBlockErase;
    protected Bit canSupportBlockWrite;
    protected BitList reserved0 = new BitList(6);
    protected UnsignedShort maxNumSelectFiltersPerQuery;

    public C1G2LLRPCapabilities() {
    }

    public C1G2LLRPCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2LLRPCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.canSupportBlockErase == null) {
            LOGGER.warn((Object)" canSupportBlockErase not set");
            throw new MissingParameterException(" canSupportBlockErase not set  for Parameter of Type C1G2LLRPCapabilities");
        }
        resultBits.append(this.canSupportBlockErase.encodeBinary());
        if (this.canSupportBlockWrite == null) {
            LOGGER.warn((Object)" canSupportBlockWrite not set");
            throw new MissingParameterException(" canSupportBlockWrite not set  for Parameter of Type C1G2LLRPCapabilities");
        }
        resultBits.append(this.canSupportBlockWrite.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.maxNumSelectFiltersPerQuery == null) {
            LOGGER.warn((Object)" maxNumSelectFiltersPerQuery not set");
            throw new MissingParameterException(" maxNumSelectFiltersPerQuery not set  for Parameter of Type C1G2LLRPCapabilities");
        }
        resultBits.append(this.maxNumSelectFiltersPerQuery.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.canSupportBlockErase == null) {
            LOGGER.warn((Object)" canSupportBlockErase not set");
            throw new MissingParameterException(" canSupportBlockErase not set");
        }
        element.addContent(this.canSupportBlockErase.encodeXML("CanSupportBlockErase", ns));
        if (this.canSupportBlockWrite == null) {
            LOGGER.warn((Object)" canSupportBlockWrite not set");
            throw new MissingParameterException(" canSupportBlockWrite not set");
        }
        element.addContent(this.canSupportBlockWrite.encodeXML("CanSupportBlockWrite", ns));
        if (this.maxNumSelectFiltersPerQuery == null) {
            LOGGER.warn((Object)" maxNumSelectFiltersPerQuery not set");
            throw new MissingParameterException(" maxNumSelectFiltersPerQuery not set");
        }
        element.addContent(this.maxNumSelectFiltersPerQuery.encodeXML("MaxNumSelectFiltersPerQuery", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.canSupportBlockErase = new Bit(binary.subList(position, Bit.length()));
        this.canSupportBlockWrite = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        this.maxNumSelectFiltersPerQuery = new UnsignedShort(binary.subList(position += this.reserved0.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("CanSupportBlockErase", ns);
        if (temp != null) {
            this.canSupportBlockErase = new Bit(temp);
        }
        element.removeChild("CanSupportBlockErase", ns);
        temp = element.getChild("CanSupportBlockWrite", ns);
        if (temp != null) {
            this.canSupportBlockWrite = new Bit(temp);
        }
        element.removeChild("CanSupportBlockWrite", ns);
        temp = element.getChild("MaxNumSelectFiltersPerQuery", ns);
        if (temp != null) {
            this.maxNumSelectFiltersPerQuery = new UnsignedShort(temp);
        }
        element.removeChild("MaxNumSelectFiltersPerQuery", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2LLRPCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setCanSupportBlockErase(Bit canSupportBlockErase) {
        this.canSupportBlockErase = canSupportBlockErase;
    }

    public void setCanSupportBlockWrite(Bit canSupportBlockWrite) {
        this.canSupportBlockWrite = canSupportBlockWrite;
    }

    public void setMaxNumSelectFiltersPerQuery(UnsignedShort maxNumSelectFiltersPerQuery) {
        this.maxNumSelectFiltersPerQuery = maxNumSelectFiltersPerQuery;
    }

    public Bit getCanSupportBlockErase() {
        return this.canSupportBlockErase;
    }

    public Bit getCanSupportBlockWrite() {
        return this.canSupportBlockWrite;
    }

    public UnsignedShort getMaxNumSelectFiltersPerQuery() {
        return this.maxNumSelectFiltersPerQuery;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2LLRPCapabilities";
    }

    public String toString() {
        String result = "C1G2LLRPCapabilities: ";
        result = result + ", canSupportBlockErase: ";
        result = result + this.canSupportBlockErase;
        result = result + ", canSupportBlockWrite: ";
        result = result + this.canSupportBlockWrite;
        result = result + ", maxNumSelectFiltersPerQuery: ";
        result = result + this.maxNumSelectFiltersPerQuery;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

