/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.C1G2LockDataField;
import org.llrp.ltk.generated.enumerations.C1G2LockPrivilege;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;

public class C1G2LockPayload
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(345);
    private static final Logger LOGGER = Logger.getLogger(C1G2LockPayload.class);
    protected C1G2LockPrivilege privilege;
    protected C1G2LockDataField dataField;

    public C1G2LockPayload() {
    }

    public C1G2LockPayload(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2LockPayload(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.privilege == null) {
            LOGGER.warn((Object)" privilege not set");
            throw new MissingParameterException(" privilege not set  for Parameter of Type C1G2LockPayload");
        }
        resultBits.append(this.privilege.encodeBinary());
        if (this.dataField == null) {
            LOGGER.warn((Object)" dataField not set");
            throw new MissingParameterException(" dataField not set  for Parameter of Type C1G2LockPayload");
        }
        resultBits.append(this.dataField.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.privilege == null) {
            LOGGER.warn((Object)" privilege not set");
            throw new MissingParameterException(" privilege not set");
        }
        element.addContent(this.privilege.encodeXML("Privilege", ns));
        if (this.dataField == null) {
            LOGGER.warn((Object)" dataField not set");
            throw new MissingParameterException(" dataField not set");
        }
        element.addContent(this.dataField.encodeXML("DataField", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.privilege = new C1G2LockPrivilege(binary.subList(position, C1G2LockPrivilege.length()));
        this.dataField = new C1G2LockDataField(binary.subList(position += C1G2LockPrivilege.length(), C1G2LockDataField.length()));
        position += C1G2LockDataField.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Privilege", ns);
        if (temp != null) {
            this.privilege = new C1G2LockPrivilege(temp);
        }
        element.removeChild("Privilege", ns);
        temp = element.getChild("DataField", ns);
        if (temp != null) {
            this.dataField = new C1G2LockDataField(temp);
        }
        element.removeChild("DataField", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2LockPayload has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setPrivilege(C1G2LockPrivilege privilege) {
        this.privilege = privilege;
    }

    public void setDataField(C1G2LockDataField dataField) {
        this.dataField = dataField;
    }

    public C1G2LockPrivilege getPrivilege() {
        return this.privilege;
    }

    public C1G2LockDataField getDataField() {
        return this.dataField;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2LockPayload";
    }

    public String toString() {
        String result = "C1G2LockPayload: ";
        result = result + ", privilege: ";
        result = result + this.privilege;
        result = result + ", dataField: ";
        result = result + this.dataField;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

