/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.C1G2ReadResultType;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpecResult;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class C1G2ReadOpSpecResult
extends TLVParameter
implements AccessCommandOpSpecResult {
    public static final SignedShort TYPENUM = new SignedShort(349);
    private static final Logger LOGGER = Logger.getLogger(C1G2ReadOpSpecResult.class);
    protected C1G2ReadResultType result;
    protected UnsignedShort opSpecID;
    protected UnsignedShortArray_HEX readData;

    public C1G2ReadOpSpecResult() {
    }

    public C1G2ReadOpSpecResult(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2ReadOpSpecResult(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.result == null) {
            LOGGER.warn((Object)" result not set");
            throw new MissingParameterException(" result not set  for Parameter of Type C1G2ReadOpSpecResult");
        }
        resultBits.append(this.result.encodeBinary());
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set  for Parameter of Type C1G2ReadOpSpecResult");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.readData == null) {
            LOGGER.warn((Object)" readData not set");
            throw new MissingParameterException(" readData not set  for Parameter of Type C1G2ReadOpSpecResult");
        }
        resultBits.append(this.readData.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.result == null) {
            LOGGER.warn((Object)" result not set");
            throw new MissingParameterException(" result not set");
        }
        element.addContent(this.result.encodeXML("Result", ns));
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.readData == null) {
            LOGGER.warn((Object)" readData not set");
            throw new MissingParameterException(" readData not set");
        }
        element.addContent(this.readData.encodeXML("ReadData", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.result = new C1G2ReadResultType(binary.subList(position, C1G2ReadResultType.length()));
        this.opSpecID = new UnsignedShort(binary.subList(position += C1G2ReadResultType.length(), UnsignedShort.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length())).toShort();
        tempLength = UnsignedShortArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.readData = new UnsignedShortArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UnsignedShortArray_HEX with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for readData ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Result", ns);
        if (temp != null) {
            this.result = new C1G2ReadResultType(temp);
        }
        element.removeChild("Result", ns);
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        element.removeChild("OpSpecID", ns);
        temp = element.getChild("ReadData", ns);
        if (temp != null) {
            this.readData = new UnsignedShortArray_HEX(temp);
        }
        element.removeChild("ReadData", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2ReadOpSpecResult has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setResult(C1G2ReadResultType result) {
        this.result = result;
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setReadData(UnsignedShortArray_HEX readData) {
        this.readData = readData;
    }

    public C1G2ReadResultType getResult() {
        return this.result;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedShortArray_HEX getReadData() {
        return this.readData;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2ReadOpSpecResult";
    }

    public String toString() {
        String result = "C1G2ReadOpSpecResult: ";
        result = result + ", result: ";
        result = result + result;
        result = result + ", opSpecID: ";
        result = result + this.opSpecID;
        result = result + ", readData: ";
        result = result + this.readData;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

