/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolSingulationDetails;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2SingulationDetails
extends TVParameter
implements AirProtocolSingulationDetails {
    public static final SignedShort TYPENUM = new SignedShort(18);
    private static final Logger LOGGER = Logger.getLogger(C1G2SingulationDetails.class);
    protected UnsignedShort numCollisionSlots;
    protected UnsignedShort numEmptySlots;

    public C1G2SingulationDetails() {
    }

    public C1G2SingulationDetails(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2SingulationDetails(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.numCollisionSlots == null) {
            LOGGER.warn((Object)" numCollisionSlots not set");
            throw new MissingParameterException(" numCollisionSlots not set  for Parameter of Type C1G2SingulationDetails");
        }
        resultBits.append(this.numCollisionSlots.encodeBinary());
        if (this.numEmptySlots == null) {
            LOGGER.warn((Object)" numEmptySlots not set");
            throw new MissingParameterException(" numEmptySlots not set  for Parameter of Type C1G2SingulationDetails");
        }
        resultBits.append(this.numEmptySlots.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.numCollisionSlots == null) {
            LOGGER.warn((Object)" numCollisionSlots not set");
            throw new MissingParameterException(" numCollisionSlots not set");
        }
        element.addContent(this.numCollisionSlots.encodeXML("NumCollisionSlots", ns));
        if (this.numEmptySlots == null) {
            LOGGER.warn((Object)" numEmptySlots not set");
            throw new MissingParameterException(" numEmptySlots not set");
        }
        element.addContent(this.numEmptySlots.encodeXML("NumEmptySlots", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.numCollisionSlots = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.numEmptySlots = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("NumCollisionSlots", ns);
        if (temp != null) {
            this.numCollisionSlots = new UnsignedShort(temp);
        }
        element.removeChild("NumCollisionSlots", ns);
        temp = element.getChild("NumEmptySlots", ns);
        if (temp != null) {
            this.numEmptySlots = new UnsignedShort(temp);
        }
        element.removeChild("NumEmptySlots", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2SingulationDetails has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setNumCollisionSlots(UnsignedShort numCollisionSlots) {
        this.numCollisionSlots = numCollisionSlots;
    }

    public void setNumEmptySlots(UnsignedShort numEmptySlots) {
        this.numEmptySlots = numEmptySlots;
    }

    public UnsignedShort getNumCollisionSlots() {
        return this.numCollisionSlots;
    }

    public UnsignedShort getNumEmptySlots() {
        return this.numEmptySlots;
    }

    public static Integer length() {
        int tempLength = 8;
        tempLength += UnsignedShort.length();
        return tempLength += UnsignedShort.length();
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2SingulationDetails";
    }

    public String toString() {
        String result = "C1G2SingulationDetails: ";
        result = result + ", numCollisionSlots: ";
        result = result + this.numCollisionSlots;
        result = result + ", numEmptySlots: ";
        result = result + this.numEmptySlots;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

