/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolTagSpec;
import org.llrp.ltk.generated.parameters.C1G2TargetTag;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C1G2TagSpec
extends TLVParameter
implements AirProtocolTagSpec {
    public static final SignedShort TYPENUM = new SignedShort(338);
    private static final Logger LOGGER = Logger.getLogger(C1G2TagSpec.class);
    protected List<C1G2TargetTag> c1G2TargetTagList = new LinkedList<C1G2TargetTag>();

    public C1G2TagSpec() {
    }

    public C1G2TagSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2TagSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.c1G2TargetTagList == null) {
            LOGGER.warn((Object)" c1G2TargetTagList not set");
            throw new MissingParameterException(" c1G2TargetTagList not set");
        }
        for (C1G2TargetTag field : this.c1G2TargetTagList) {
            resultBits.append(field.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.c1G2TargetTagList == null) {
            LOGGER.warn((Object)" c1G2TargetTagList not set");
            throw new MissingParameterException("  c1G2TargetTagList not set");
        }
        for (C1G2TargetTag field : this.c1G2TargetTagList) {
            element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.c1G2TargetTagList = new LinkedList<C1G2TargetTag>();
        LOGGER.debug((Object)"decoding parameter c1G2TargetTagList ");
        while (position < binary.length()) {
            SignedShort type;
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                short tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2TargetTag.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2TargetTag.length();
                }
                this.c1G2TargetTagList.add(new C1G2TargetTag(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2TargetTag to c1G2TargetTagList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.c1G2TargetTagList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional c1G2TargetTagList");
            throw new MissingParameterException("C1G2TagSpec misses non optional parameter of type C1G2TargetTag");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Object temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        this.c1G2TargetTagList = new LinkedList<C1G2TargetTag>();
        tempList = element.getChildren("C1G2TargetTag", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"C1G2TagSpec misses non optional parameter of type c1G2TargetTagList");
            throw new MissingParameterException("C1G2TagSpec misses non optional parameter of type c1G2TargetTagList");
        }
        for (Element e : tempList) {
            this.c1G2TargetTagList.add(new C1G2TargetTag(e));
            LOGGER.debug((Object)"adding C1G2TargetTag to c1G2TargetTagList ");
        }
        element.removeChildren("C1G2TargetTag", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2TagSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setC1G2TargetTagList(List<C1G2TargetTag> c1G2TargetTagList) {
        this.c1G2TargetTagList = c1G2TargetTagList;
    }

    public List<C1G2TargetTag> getC1G2TargetTagList() {
        return this.c1G2TargetTagList;
    }

    public void addToC1G2TargetTagList(C1G2TargetTag c1G2TargetTag) {
        if (this.c1G2TargetTagList == null) {
            this.c1G2TargetTagList = new LinkedList<C1G2TargetTag>();
        }
        this.c1G2TargetTagList.add(c1G2TargetTag);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2TagSpec";
    }

    public String toString() {
        String result = "C1G2TagSpec: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

