/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2TargetTag
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(339);
    private static final Logger LOGGER = Logger.getLogger(C1G2TargetTag.class);
    protected TwoBitField mB;
    protected Bit match;
    protected BitList reserved0 = new BitList(5);
    protected UnsignedShort pointer;
    protected BitArray_HEX tagMask;
    protected BitArray_HEX tagData;

    public C1G2TargetTag() {
    }

    public C1G2TargetTag(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2TargetTag(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set  for Parameter of Type C1G2TargetTag");
        }
        resultBits.append(this.mB.encodeBinary());
        if (this.match == null) {
            LOGGER.warn((Object)" match not set");
            throw new MissingParameterException(" match not set  for Parameter of Type C1G2TargetTag");
        }
        resultBits.append(this.match.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.pointer == null) {
            LOGGER.warn((Object)" pointer not set");
            throw new MissingParameterException(" pointer not set  for Parameter of Type C1G2TargetTag");
        }
        resultBits.append(this.pointer.encodeBinary());
        if (this.tagMask == null) {
            LOGGER.warn((Object)" tagMask not set");
            throw new MissingParameterException(" tagMask not set  for Parameter of Type C1G2TargetTag");
        }
        resultBits.append(this.tagMask.encodeBinary());
        if (this.tagData == null) {
            LOGGER.warn((Object)" tagData not set");
            throw new MissingParameterException(" tagData not set  for Parameter of Type C1G2TargetTag");
        }
        resultBits.append(this.tagData.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set");
        }
        element.addContent(this.mB.encodeXML("MB", ns));
        if (this.match == null) {
            LOGGER.warn((Object)" match not set");
            throw new MissingParameterException(" match not set");
        }
        element.addContent(this.match.encodeXML("Match", ns));
        if (this.pointer == null) {
            LOGGER.warn((Object)" pointer not set");
            throw new MissingParameterException(" pointer not set");
        }
        element.addContent(this.pointer.encodeXML("Pointer", ns));
        if (this.tagMask == null) {
            LOGGER.warn((Object)" tagMask not set");
            throw new MissingParameterException(" tagMask not set");
        }
        element.addContent(this.tagMask.encodeXML("TagMask", ns));
        if (this.tagData == null) {
            LOGGER.warn((Object)" tagData not set");
            throw new MissingParameterException(" tagData not set");
        }
        element.addContent(this.tagData.encodeXML("TagData", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.mB = new TwoBitField(binary.subList(position, TwoBitField.length()));
        this.match = new Bit(binary.subList(position += TwoBitField.length(), Bit.length()));
        position += Bit.length();
        this.pointer = new UnsignedShort(binary.subList(position += this.reserved0.length(), UnsignedShort.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length())).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.tagMask = new BitArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: BitArray_HEX with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for tagMask ");
        }
        fieldCount = new UnsignedShort(binary.subList(position, UnsignedShort.length())).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.tagData = new BitArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: BitArray_HEX with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for tagData ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("MB", ns);
        if (temp != null) {
            this.mB = new TwoBitField(temp);
        }
        element.removeChild("MB", ns);
        temp = element.getChild("Match", ns);
        if (temp != null) {
            this.match = new Bit(temp);
        }
        element.removeChild("Match", ns);
        temp = element.getChild("Pointer", ns);
        if (temp != null) {
            this.pointer = new UnsignedShort(temp);
        }
        element.removeChild("Pointer", ns);
        temp = element.getChild("TagMask", ns);
        if (temp != null) {
            this.tagMask = new BitArray_HEX(temp);
        }
        element.removeChild("TagMask", ns);
        temp = element.getChild("TagData", ns);
        if (temp != null) {
            this.tagData = new BitArray_HEX(temp);
        }
        element.removeChild("TagData", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2TargetTag has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setMB(TwoBitField mB) {
        this.mB = mB;
    }

    public void setMatch(Bit match) {
        this.match = match;
    }

    public void setPointer(UnsignedShort pointer) {
        this.pointer = pointer;
    }

    public void setTagMask(BitArray_HEX tagMask) {
        this.tagMask = tagMask;
    }

    public void setTagData(BitArray_HEX tagData) {
        this.tagData = tagData;
    }

    public TwoBitField getMB() {
        return this.mB;
    }

    public Bit getMatch() {
        return this.match;
    }

    public UnsignedShort getPointer() {
        return this.pointer;
    }

    public BitArray_HEX getTagMask() {
        return this.tagMask;
    }

    public BitArray_HEX getTagData() {
        return this.tagData;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "C1G2TargetTag";
    }

    public String toString() {
        String result = "C1G2TargetTag: ";
        result = result + ", mB: ";
        result = result + this.mB;
        result = result + ", match: ";
        result = result + this.match;
        result = result + ", pointer: ";
        result = result + this.pointer;
        result = result + ", tagMask: ";
        result = result + this.tagMask;
        result = result + ", tagData: ";
        result = result + this.tagData;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

