/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.types.BytesToEnd_HEX;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;

public class Custom
extends TLVParameter
implements SpecParameter {
    public static final SignedShort TYPENUM = new SignedShort(1023);
    private static final Logger LOGGER = Logger.getLogger(Custom.class);
    protected UnsignedInteger vendorIdentifier;
    protected UnsignedInteger parameterSubtype;
    protected BytesToEnd_HEX data;

    public Custom() {
    }

    public Custom(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public Custom(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn((Object)" vendorIdentifier not set");
            throw new MissingParameterException(" vendorIdentifier not set  for Parameter of Type Custom");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn((Object)" parameterSubtype not set");
            throw new MissingParameterException(" parameterSubtype not set  for Parameter of Type Custom");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.data == null) {
            LOGGER.warn((Object)" data not set");
            throw new MissingParameterException(" data not set  for Parameter of Type Custom");
        }
        resultBits.append(this.data.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.vendorIdentifier == null) {
            LOGGER.warn((Object)" vendorIdentifier not set");
            throw new MissingParameterException(" vendorIdentifier not set");
        }
        element.addContent(this.vendorIdentifier.encodeXML("VendorIdentifier", ns));
        if (this.parameterSubtype == null) {
            LOGGER.warn((Object)" parameterSubtype not set");
            throw new MissingParameterException(" parameterSubtype not set");
        }
        element.addContent(this.parameterSubtype.encodeXML("ParameterSubtype", ns));
        if (this.data == null) {
            LOGGER.warn((Object)" data not set");
            throw new MissingParameterException(" data not set");
        }
        element.addContent(this.data.encodeXML("Data", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        this.data = new BytesToEnd_HEX(binary.subList(position += UnsignedInteger.length(), binary.length() - position));
        position += binary.length() - position;
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("VendorIdentifier", ns);
        if (temp != null) {
            this.vendorIdentifier = new UnsignedInteger(temp);
        }
        element.removeChild("VendorIdentifier", ns);
        temp = element.getChild("ParameterSubtype", ns);
        if (temp != null) {
            this.parameterSubtype = new UnsignedInteger(temp);
        }
        element.removeChild("ParameterSubtype", ns);
        temp = element.getChild("Data", ns);
        if (temp != null) {
            this.data = new BytesToEnd_HEX(temp);
        }
        element.removeChild("Data", ns);
        if (element.getChildren().size() > 0) {
            String message = "Custom has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setVendorIdentifier(UnsignedInteger vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
    }

    public void setParameterSubtype(UnsignedInteger parameterSubtype) {
        this.parameterSubtype = parameterSubtype;
    }

    public void setData(BytesToEnd_HEX data) {
        this.data = data;
    }

    public UnsignedInteger getVendorIdentifier() {
        return this.vendorIdentifier;
    }

    public UnsignedInteger getParameterSubtype() {
        return this.parameterSubtype;
    }

    public BytesToEnd_HEX getData() {
        return this.data;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "Custom";
    }

    public String toString() {
        String result = "Custom: ";
        result = result + ", vendorIdentifier: ";
        result = result + this.vendorIdentifier;
        result = result + ", parameterSubtype: ";
        result = result + this.parameterSubtype;
        result = result + ", data: ";
        result = result + this.data;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

