/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.NotificationEventType;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;

public class EventNotificationState
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(245);
    private static final Logger LOGGER = Logger.getLogger(EventNotificationState.class);
    protected NotificationEventType eventType;
    protected Bit notificationState;
    protected BitList reserved0 = new BitList(7);

    public EventNotificationState() {
    }

    public EventNotificationState(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public EventNotificationState(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set  for Parameter of Type EventNotificationState");
        }
        resultBits.append(this.eventType.encodeBinary());
        if (this.notificationState == null) {
            LOGGER.warn((Object)" notificationState not set");
            throw new MissingParameterException(" notificationState not set  for Parameter of Type EventNotificationState");
        }
        resultBits.append(this.notificationState.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set");
        }
        element.addContent(this.eventType.encodeXML("EventType", ns));
        if (this.notificationState == null) {
            LOGGER.warn((Object)" notificationState not set");
            throw new MissingParameterException(" notificationState not set");
        }
        element.addContent(this.notificationState.encodeXML("NotificationState", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.eventType = new NotificationEventType(binary.subList(position, NotificationEventType.length()));
        this.notificationState = new Bit(binary.subList(position += NotificationEventType.length(), Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EventType", ns);
        if (temp != null) {
            this.eventType = new NotificationEventType(temp);
        }
        element.removeChild("EventType", ns);
        temp = element.getChild("NotificationState", ns);
        if (temp != null) {
            this.notificationState = new Bit(temp);
        }
        element.removeChild("NotificationState", ns);
        if (element.getChildren().size() > 0) {
            String message = "EventNotificationState has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventType(NotificationEventType eventType) {
        this.eventType = eventType;
    }

    public void setNotificationState(Bit notificationState) {
        this.notificationState = notificationState;
    }

    public NotificationEventType getEventType() {
        return this.eventType;
    }

    public Bit getNotificationState() {
        return this.notificationState;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "EventNotificationState";
    }

    public String toString() {
        String result = "EventNotificationState: ";
        result = result + ", eventType: ";
        result = result + this.eventType;
        result = result + ", notificationState: ";
        result = result + this.notificationState;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

