/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedIntegerArray;
import org.llrp.ltk.types.UnsignedShort;

public class FixedFrequencyTable
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(148);
    private static final Logger LOGGER = Logger.getLogger(FixedFrequencyTable.class);
    protected UnsignedIntegerArray frequency;

    public FixedFrequencyTable() {
    }

    public FixedFrequencyTable(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public FixedFrequencyTable(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.frequency == null) {
            LOGGER.warn((Object)" frequency not set");
            throw new MissingParameterException(" frequency not set  for Parameter of Type FixedFrequencyTable");
        }
        resultBits.append(this.frequency.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.frequency == null) {
            LOGGER.warn((Object)" frequency not set");
            throw new MissingParameterException(" frequency not set");
        }
        element.addContent(this.frequency.encodeXML("Frequency", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        short fieldCount = new UnsignedShort(binary.subList(position, UnsignedShort.length())).toShort();
        tempLength = UnsignedIntegerArray.length() * fieldCount + UnsignedShort.length();
        this.frequency = new UnsignedIntegerArray(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UnsignedIntegerArray with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for frequency ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Frequency", ns);
        if (temp != null) {
            this.frequency = new UnsignedIntegerArray(temp);
        }
        element.removeChild("Frequency", ns);
        if (element.getChildren().size() > 0) {
            String message = "FixedFrequencyTable has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setFrequency(UnsignedIntegerArray frequency) {
        this.frequency = frequency;
    }

    public UnsignedIntegerArray getFrequency() {
        return this.frequency;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "FixedFrequencyTable";
    }

    public String toString() {
        String result = "FixedFrequencyTable: ";
        result = result + ", frequency: ";
        result = result + this.frequency;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

