/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.Timestamp;
import org.llrp.ltk.generated.parameters.UTCTimestamp;
import org.llrp.ltk.generated.parameters.Uptime;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedByte;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class FrequencyRSSILevelEntry
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(243);
    private static final Logger LOGGER = Logger.getLogger(FrequencyRSSILevelEntry.class);
    protected UnsignedInteger frequency;
    protected UnsignedInteger bandwidth;
    protected SignedByte averageRSSI;
    protected SignedByte peakRSSI;
    protected Timestamp timestamp;

    public FrequencyRSSILevelEntry() {
    }

    public FrequencyRSSILevelEntry(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public FrequencyRSSILevelEntry(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.frequency == null) {
            LOGGER.warn((Object)" frequency not set");
            throw new MissingParameterException(" frequency not set  for Parameter of Type FrequencyRSSILevelEntry");
        }
        resultBits.append(this.frequency.encodeBinary());
        if (this.bandwidth == null) {
            LOGGER.warn((Object)" bandwidth not set");
            throw new MissingParameterException(" bandwidth not set  for Parameter of Type FrequencyRSSILevelEntry");
        }
        resultBits.append(this.bandwidth.encodeBinary());
        if (this.averageRSSI == null) {
            LOGGER.warn((Object)" averageRSSI not set");
            throw new MissingParameterException(" averageRSSI not set  for Parameter of Type FrequencyRSSILevelEntry");
        }
        resultBits.append(this.averageRSSI.encodeBinary());
        if (this.peakRSSI == null) {
            LOGGER.warn((Object)" peakRSSI not set");
            throw new MissingParameterException(" peakRSSI not set  for Parameter of Type FrequencyRSSILevelEntry");
        }
        resultBits.append(this.peakRSSI.encodeBinary());
        if (this.timestamp == null) {
            LOGGER.warn((Object)" timestamp not set");
            throw new MissingParameterException(" timestamp not set");
        }
        resultBits.append(this.timestamp.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.frequency == null) {
            LOGGER.warn((Object)" frequency not set");
            throw new MissingParameterException(" frequency not set");
        }
        element.addContent(this.frequency.encodeXML("Frequency", ns));
        if (this.bandwidth == null) {
            LOGGER.warn((Object)" bandwidth not set");
            throw new MissingParameterException(" bandwidth not set");
        }
        element.addContent(this.bandwidth.encodeXML("Bandwidth", ns));
        if (this.averageRSSI == null) {
            LOGGER.warn((Object)" averageRSSI not set");
            throw new MissingParameterException(" averageRSSI not set");
        }
        element.addContent(this.averageRSSI.encodeXML("AverageRSSI", ns));
        if (this.peakRSSI == null) {
            LOGGER.warn((Object)" peakRSSI not set");
            throw new MissingParameterException(" peakRSSI not set");
        }
        element.addContent(this.peakRSSI.encodeXML("PeakRSSI", ns));
        if (this.timestamp == null) {
            LOGGER.info((Object)"timestamp not set");
            throw new MissingParameterException("timestamp not set");
        }
        element.addContent(this.timestamp.encodeXML(this.timestamp.getClass().getSimpleName(), ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.frequency = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.bandwidth = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        this.averageRSSI = new SignedByte(binary.subList(position += UnsignedInteger.length(), SignedByte.length()));
        this.peakRSSI = new SignedByte(binary.subList(position += SignedByte.length(), SignedByte.length()));
        position += SignedByte.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"FrequencyRSSILevelEntry misses non optional parameter of type Timestamp");
            throw new MissingParameterException("FrequencyRSSILevelEntry misses non optional parameter of type Timestamp");
        }
        boolean found = false;
        LOGGER.debug((Object)"decoding choice type Timestamp ");
        if (binary.get(position)) {
            tempLength = UTCTimestamp.length();
        }
        if (type != null && type.equals(UTCTimestamp.TYPENUM)) {
            this.timestamp = new UTCTimestamp(binary.subList(position, tempLength));
            LOGGER.debug((Object)(" timestamp instatiated to UTCTimestamp with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (binary.get(position)) {
            tempLength = Uptime.length();
        }
        if (type != null && type.equals(Uptime.TYPENUM)) {
            this.timestamp = new Uptime(binary.subList(position, tempLength));
            LOGGER.debug((Object)(" timestamp instatiated to Uptime with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (!found) {
            LOGGER.warn((Object)"encoded message misses non optional parameter timestamp");
            throw new MissingParameterException("FrequencyRSSILevelEntry misses non optional parameter of type Timestamp");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Frequency", ns);
        if (temp != null) {
            this.frequency = new UnsignedInteger(temp);
        }
        element.removeChild("Frequency", ns);
        temp = element.getChild("Bandwidth", ns);
        if (temp != null) {
            this.bandwidth = new UnsignedInteger(temp);
        }
        element.removeChild("Bandwidth", ns);
        temp = element.getChild("AverageRSSI", ns);
        if (temp != null) {
            this.averageRSSI = new SignedByte(temp);
        }
        element.removeChild("AverageRSSI", ns);
        temp = element.getChild("PeakRSSI", ns);
        if (temp != null) {
            this.peakRSSI = new SignedByte(temp);
        }
        element.removeChild("PeakRSSI", ns);
        boolean found = false;
        LOGGER.debug((Object)"decoding choice type Timestamp ");
        temp = element.getChild("UTCTimestamp", ns);
        if (temp != null) {
            this.timestamp = new UTCTimestamp(temp);
            LOGGER.debug((Object)" timestamp instatiated to UTCTimestamp with");
            found = true;
        }
        element.removeChild("UTCTimestamp", ns);
        temp = element.getChild("Uptime", ns);
        if (temp != null) {
            this.timestamp = new Uptime(temp);
            LOGGER.debug((Object)" timestamp instatiated to Uptime with");
            found = true;
        }
        element.removeChild("Uptime", ns);
        if (!found) {
            LOGGER.info((Object)"FrequencyRSSILevelEntry misses optional parameter of type timestampList");
        }
        if (element.getChildren().size() > 0) {
            String message = "FrequencyRSSILevelEntry has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setFrequency(UnsignedInteger frequency) {
        this.frequency = frequency;
    }

    public void setBandwidth(UnsignedInteger bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setAverageRSSI(SignedByte averageRSSI) {
        this.averageRSSI = averageRSSI;
    }

    public void setPeakRSSI(SignedByte peakRSSI) {
        this.peakRSSI = peakRSSI;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public UnsignedInteger getFrequency() {
        return this.frequency;
    }

    public UnsignedInteger getBandwidth() {
        return this.bandwidth;
    }

    public SignedByte getAverageRSSI() {
        return this.averageRSSI;
    }

    public SignedByte getPeakRSSI() {
        return this.peakRSSI;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "FrequencyRSSILevelEntry";
    }

    public String toString() {
        String result = "FrequencyRSSILevelEntry: ";
        result = result + ", frequency: ";
        result = result + this.frequency;
        result = result + ", bandwidth: ";
        result = result + this.bandwidth;
        result = result + ", averageRSSI: ";
        result = result + this.averageRSSI;
        result = result + ", peakRSSI: ";
        result = result + this.peakRSSI;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

