/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class GPIEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(248);
    private static final Logger LOGGER = Logger.getLogger(GPIEvent.class);
    protected UnsignedShort gPIPortNumber;
    protected Bit gPIEvent;
    protected BitList reserved0 = new BitList(7);

    public GPIEvent() {
    }

    public GPIEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GPIEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.gPIPortNumber == null) {
            LOGGER.warn((Object)" gPIPortNumber not set");
            throw new MissingParameterException(" gPIPortNumber not set  for Parameter of Type GPIEvent");
        }
        resultBits.append(this.gPIPortNumber.encodeBinary());
        if (this.gPIEvent == null) {
            LOGGER.warn((Object)" gPIEvent not set");
            throw new MissingParameterException(" gPIEvent not set  for Parameter of Type GPIEvent");
        }
        resultBits.append(this.gPIEvent.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.gPIPortNumber == null) {
            LOGGER.warn((Object)" gPIPortNumber not set");
            throw new MissingParameterException(" gPIPortNumber not set");
        }
        element.addContent(this.gPIPortNumber.encodeXML("GPIPortNumber", ns));
        if (this.gPIEvent == null) {
            LOGGER.warn((Object)" gPIEvent not set");
            throw new MissingParameterException(" gPIEvent not set");
        }
        element.addContent(this.gPIEvent.encodeXML("GPIEvent", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.gPIPortNumber = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.gPIEvent = new Bit(binary.subList(position += UnsignedShort.length(), Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("GPIPortNumber", ns);
        if (temp != null) {
            this.gPIPortNumber = new UnsignedShort(temp);
        }
        element.removeChild("GPIPortNumber", ns);
        temp = element.getChild("GPIEvent", ns);
        if (temp != null) {
            this.gPIEvent = new Bit(temp);
        }
        element.removeChild("GPIEvent", ns);
        if (element.getChildren().size() > 0) {
            String message = "GPIEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setGPIPortNumber(UnsignedShort gPIPortNumber) {
        this.gPIPortNumber = gPIPortNumber;
    }

    public void setGPIEvent(Bit gPIEvent) {
        this.gPIEvent = gPIEvent;
    }

    public UnsignedShort getGPIPortNumber() {
        return this.gPIPortNumber;
    }

    public Bit getGPIEvent() {
        return this.gPIEvent;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "GPIEvent";
    }

    public String toString() {
        String result = "GPIEvent: ";
        result = result + ", gPIPortNumber: ";
        result = result + this.gPIPortNumber;
        result = result + ", gPIEvent: ";
        result = result + this.gPIEvent;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

