/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.GPIPortState;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class GPIPortCurrentState
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(225);
    private static final Logger LOGGER = Logger.getLogger(GPIPortCurrentState.class);
    protected UnsignedShort gPIPortNum;
    protected Bit config;
    protected BitList reserved0 = new BitList(7);
    protected GPIPortState state;

    public GPIPortCurrentState() {
    }

    public GPIPortCurrentState(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GPIPortCurrentState(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.gPIPortNum == null) {
            LOGGER.warn((Object)" gPIPortNum not set");
            throw new MissingParameterException(" gPIPortNum not set  for Parameter of Type GPIPortCurrentState");
        }
        resultBits.append(this.gPIPortNum.encodeBinary());
        if (this.config == null) {
            LOGGER.warn((Object)" config not set");
            throw new MissingParameterException(" config not set  for Parameter of Type GPIPortCurrentState");
        }
        resultBits.append(this.config.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.state == null) {
            LOGGER.warn((Object)" state not set");
            throw new MissingParameterException(" state not set  for Parameter of Type GPIPortCurrentState");
        }
        resultBits.append(this.state.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.gPIPortNum == null) {
            LOGGER.warn((Object)" gPIPortNum not set");
            throw new MissingParameterException(" gPIPortNum not set");
        }
        element.addContent(this.gPIPortNum.encodeXML("GPIPortNum", ns));
        if (this.config == null) {
            LOGGER.warn((Object)" config not set");
            throw new MissingParameterException(" config not set");
        }
        element.addContent(this.config.encodeXML("Config", ns));
        if (this.state == null) {
            LOGGER.warn((Object)" state not set");
            throw new MissingParameterException(" state not set");
        }
        element.addContent(this.state.encodeXML("State", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.gPIPortNum = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.config = new Bit(binary.subList(position += UnsignedShort.length(), Bit.length()));
        position += Bit.length();
        this.state = new GPIPortState(binary.subList(position += this.reserved0.length(), GPIPortState.length()));
        position += GPIPortState.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("GPIPortNum", ns);
        if (temp != null) {
            this.gPIPortNum = new UnsignedShort(temp);
        }
        element.removeChild("GPIPortNum", ns);
        temp = element.getChild("Config", ns);
        if (temp != null) {
            this.config = new Bit(temp);
        }
        element.removeChild("Config", ns);
        temp = element.getChild("State", ns);
        if (temp != null) {
            this.state = new GPIPortState(temp);
        }
        element.removeChild("State", ns);
        if (element.getChildren().size() > 0) {
            String message = "GPIPortCurrentState has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setGPIPortNum(UnsignedShort gPIPortNum) {
        this.gPIPortNum = gPIPortNum;
    }

    public void setConfig(Bit config) {
        this.config = config;
    }

    public void setState(GPIPortState state) {
        this.state = state;
    }

    public UnsignedShort getGPIPortNum() {
        return this.gPIPortNum;
    }

    public Bit getConfig() {
        return this.config;
    }

    public GPIPortState getState() {
        return this.state;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "GPIPortCurrentState";
    }

    public String toString() {
        String result = "GPIPortCurrentState: ";
        result = result + ", gPIPortNum: ";
        result = result + this.gPIPortNum;
        result = result + ", config: ";
        result = result + this.config;
        result = result + ", state: ";
        result = result + this.state;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

