/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class GPOWriteData
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(219);
    private static final Logger LOGGER = Logger.getLogger(GPOWriteData.class);
    protected UnsignedShort gPOPortNumber;
    protected Bit gPOData;
    protected BitList reserved0 = new BitList(7);

    public GPOWriteData() {
    }

    public GPOWriteData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GPOWriteData(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.gPOPortNumber == null) {
            LOGGER.warn((Object)" gPOPortNumber not set");
            throw new MissingParameterException(" gPOPortNumber not set  for Parameter of Type GPOWriteData");
        }
        resultBits.append(this.gPOPortNumber.encodeBinary());
        if (this.gPOData == null) {
            LOGGER.warn((Object)" gPOData not set");
            throw new MissingParameterException(" gPOData not set  for Parameter of Type GPOWriteData");
        }
        resultBits.append(this.gPOData.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.gPOPortNumber == null) {
            LOGGER.warn((Object)" gPOPortNumber not set");
            throw new MissingParameterException(" gPOPortNumber not set");
        }
        element.addContent(this.gPOPortNumber.encodeXML("GPOPortNumber", ns));
        if (this.gPOData == null) {
            LOGGER.warn((Object)" gPOData not set");
            throw new MissingParameterException(" gPOData not set");
        }
        element.addContent(this.gPOData.encodeXML("GPOData", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.gPOPortNumber = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.gPOData = new Bit(binary.subList(position += UnsignedShort.length(), Bit.length()));
        position += Bit.length();
        position += this.reserved0.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("GPOPortNumber", ns);
        if (temp != null) {
            this.gPOPortNumber = new UnsignedShort(temp);
        }
        element.removeChild("GPOPortNumber", ns);
        temp = element.getChild("GPOData", ns);
        if (temp != null) {
            this.gPOData = new Bit(temp);
        }
        element.removeChild("GPOData", ns);
        if (element.getChildren().size() > 0) {
            String message = "GPOWriteData has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setGPOPortNumber(UnsignedShort gPOPortNumber) {
        this.gPOPortNumber = gPOPortNumber;
    }

    public void setGPOData(Bit gPOData) {
        this.gPOData = gPOData;
    }

    public UnsignedShort getGPOPortNumber() {
        return this.gPOPortNumber;
    }

    public Bit getGPOData() {
        return this.gPOData;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "GPOWriteData";
    }

    public String toString() {
        String result = "GPOWriteData: ";
        result = result + ", gPOPortNumber: ";
        result = result + this.gPOPortNumber;
        result = result + ", gPOData: ";
        result = result + this.gPOData;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

