/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.GPIOCapabilities;
import org.llrp.ltk.generated.parameters.PerAntennaAirProtocol;
import org.llrp.ltk.generated.parameters.PerAntennaReceiveSensitivityRange;
import org.llrp.ltk.generated.parameters.ReceiveSensitivityTableEntry;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UTF8String_UTF_8;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralDeviceCapabilities
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(137);
    private static final Logger LOGGER = Logger.getLogger(GeneralDeviceCapabilities.class);
    protected UnsignedShort maxNumberOfAntennaSupported;
    protected Bit canSetAntennaProperties;
    protected Bit hasUTCClockCapability;
    protected BitList reserved0 = new BitList(14);
    protected UnsignedInteger deviceManufacturerName;
    protected UnsignedInteger modelName;
    protected UTF8String_UTF_8 readerFirmwareVersion;
    protected List<ReceiveSensitivityTableEntry> receiveSensitivityTableEntryList = new LinkedList<ReceiveSensitivityTableEntry>();
    protected List<PerAntennaReceiveSensitivityRange> perAntennaReceiveSensitivityRangeList = new LinkedList<PerAntennaReceiveSensitivityRange>();
    protected GPIOCapabilities gPIOCapabilities;
    protected List<PerAntennaAirProtocol> perAntennaAirProtocolList = new LinkedList<PerAntennaAirProtocol>();

    public GeneralDeviceCapabilities() {
    }

    public GeneralDeviceCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GeneralDeviceCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.maxNumberOfAntennaSupported == null) {
            LOGGER.warn((Object)" maxNumberOfAntennaSupported not set");
            throw new MissingParameterException(" maxNumberOfAntennaSupported not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.maxNumberOfAntennaSupported.encodeBinary());
        if (this.canSetAntennaProperties == null) {
            LOGGER.warn((Object)" canSetAntennaProperties not set");
            throw new MissingParameterException(" canSetAntennaProperties not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.canSetAntennaProperties.encodeBinary());
        if (this.hasUTCClockCapability == null) {
            LOGGER.warn((Object)" hasUTCClockCapability not set");
            throw new MissingParameterException(" hasUTCClockCapability not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.hasUTCClockCapability.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.deviceManufacturerName == null) {
            LOGGER.warn((Object)" deviceManufacturerName not set");
            throw new MissingParameterException(" deviceManufacturerName not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.deviceManufacturerName.encodeBinary());
        if (this.modelName == null) {
            LOGGER.warn((Object)" modelName not set");
            throw new MissingParameterException(" modelName not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.modelName.encodeBinary());
        if (this.readerFirmwareVersion == null) {
            LOGGER.warn((Object)" readerFirmwareVersion not set");
            throw new MissingParameterException(" readerFirmwareVersion not set  for Parameter of Type GeneralDeviceCapabilities");
        }
        resultBits.append(this.readerFirmwareVersion.encodeBinary());
        if (this.receiveSensitivityTableEntryList == null) {
            LOGGER.warn((Object)" receiveSensitivityTableEntryList not set");
            throw new MissingParameterException(" receiveSensitivityTableEntryList not set");
        }
        for (ReceiveSensitivityTableEntry receiveSensitivityTableEntry : this.receiveSensitivityTableEntryList) {
            resultBits.append(receiveSensitivityTableEntry.encodeBinary());
        }
        if (this.perAntennaReceiveSensitivityRangeList == null) {
            LOGGER.info((Object)" perAntennaReceiveSensitivityRangeList not set");
        } else {
            for (PerAntennaReceiveSensitivityRange perAntennaReceiveSensitivityRange : this.perAntennaReceiveSensitivityRangeList) {
                resultBits.append(perAntennaReceiveSensitivityRange.encodeBinary());
            }
        }
        if (this.gPIOCapabilities == null) {
            LOGGER.warn((Object)" gPIOCapabilities not set");
            throw new MissingParameterException(" gPIOCapabilities not set");
        }
        resultBits.append(this.gPIOCapabilities.encodeBinary());
        if (this.perAntennaAirProtocolList == null) {
            LOGGER.warn((Object)" perAntennaAirProtocolList not set");
            throw new MissingParameterException(" perAntennaAirProtocolList not set");
        }
        for (PerAntennaAirProtocol perAntennaAirProtocol : this.perAntennaAirProtocolList) {
            resultBits.append(perAntennaAirProtocol.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.maxNumberOfAntennaSupported == null) {
            LOGGER.warn((Object)" maxNumberOfAntennaSupported not set");
            throw new MissingParameterException(" maxNumberOfAntennaSupported not set");
        }
        element.addContent(this.maxNumberOfAntennaSupported.encodeXML("MaxNumberOfAntennaSupported", ns));
        if (this.canSetAntennaProperties == null) {
            LOGGER.warn((Object)" canSetAntennaProperties not set");
            throw new MissingParameterException(" canSetAntennaProperties not set");
        }
        element.addContent(this.canSetAntennaProperties.encodeXML("CanSetAntennaProperties", ns));
        if (this.hasUTCClockCapability == null) {
            LOGGER.warn((Object)" hasUTCClockCapability not set");
            throw new MissingParameterException(" hasUTCClockCapability not set");
        }
        element.addContent(this.hasUTCClockCapability.encodeXML("HasUTCClockCapability", ns));
        if (this.deviceManufacturerName == null) {
            LOGGER.warn((Object)" deviceManufacturerName not set");
            throw new MissingParameterException(" deviceManufacturerName not set");
        }
        element.addContent(this.deviceManufacturerName.encodeXML("DeviceManufacturerName", ns));
        if (this.modelName == null) {
            LOGGER.warn((Object)" modelName not set");
            throw new MissingParameterException(" modelName not set");
        }
        element.addContent(this.modelName.encodeXML("ModelName", ns));
        if (this.readerFirmwareVersion == null) {
            LOGGER.warn((Object)" readerFirmwareVersion not set");
            throw new MissingParameterException(" readerFirmwareVersion not set");
        }
        element.addContent(this.readerFirmwareVersion.encodeXML("ReaderFirmwareVersion", ns));
        if (this.receiveSensitivityTableEntryList == null) {
            LOGGER.warn((Object)" receiveSensitivityTableEntryList not set");
            throw new MissingParameterException("  receiveSensitivityTableEntryList not set");
        }
        for (ReceiveSensitivityTableEntry receiveSensitivityTableEntry : this.receiveSensitivityTableEntryList) {
            element.addContent(receiveSensitivityTableEntry.encodeXML(receiveSensitivityTableEntry.getClass().getName().replaceAll(receiveSensitivityTableEntry.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.perAntennaReceiveSensitivityRangeList == null) {
            LOGGER.info((Object)"perAntennaReceiveSensitivityRangeList not set");
        } else {
            for (PerAntennaReceiveSensitivityRange perAntennaReceiveSensitivityRange : this.perAntennaReceiveSensitivityRangeList) {
                element.addContent(perAntennaReceiveSensitivityRange.encodeXML(perAntennaReceiveSensitivityRange.getClass().getName().replaceAll(perAntennaReceiveSensitivityRange.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.gPIOCapabilities == null) {
            LOGGER.info((Object)"gPIOCapabilities not set");
            throw new MissingParameterException("gPIOCapabilities not set");
        }
        element.addContent(this.gPIOCapabilities.encodeXML(this.gPIOCapabilities.getClass().getSimpleName(), ns));
        if (this.perAntennaAirProtocolList == null) {
            LOGGER.warn((Object)" perAntennaAirProtocolList not set");
            throw new MissingParameterException("  perAntennaAirProtocolList not set");
        }
        for (PerAntennaAirProtocol perAntennaAirProtocol : this.perAntennaAirProtocolList) {
            element.addContent(perAntennaAirProtocol.encodeXML(perAntennaAirProtocol.getClass().getName().replaceAll(perAntennaAirProtocol.getClass().getPackage().getName() + ".", ""), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.maxNumberOfAntennaSupported = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.canSetAntennaProperties = new Bit(binary.subList(position += UnsignedShort.length(), Bit.length()));
        this.hasUTCClockCapability = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        this.deviceManufacturerName = new UnsignedInteger(binary.subList(position += this.reserved0.length(), UnsignedInteger.length()));
        this.modelName = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += UnsignedInteger.length(), UnsignedShort.length())).toShort();
        tempLength = UTF8String_UTF_8.length() * fieldCount + UnsignedShort.length();
        this.readerFirmwareVersion = new UTF8String_UTF_8(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UTF8String_UTF_8 with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for readerFirmwareVersion ");
        }
        this.receiveSensitivityTableEntryList = new LinkedList<ReceiveSensitivityTableEntry>();
        LOGGER.debug((Object)"decoding parameter receiveSensitivityTableEntryList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(ReceiveSensitivityTableEntry.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = ReceiveSensitivityTableEntry.length();
                }
                this.receiveSensitivityTableEntryList.add(new ReceiveSensitivityTableEntry(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding ReceiveSensitivityTableEntry to receiveSensitivityTableEntryList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.receiveSensitivityTableEntryList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional receiveSensitivityTableEntryList");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type ReceiveSensitivityTableEntry");
        }
        this.perAntennaReceiveSensitivityRangeList = new LinkedList<PerAntennaReceiveSensitivityRange>();
        LOGGER.debug((Object)"decoding parameter perAntennaReceiveSensitivityRangeList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(PerAntennaReceiveSensitivityRange.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = PerAntennaReceiveSensitivityRange.length();
                }
                this.perAntennaReceiveSensitivityRangeList.add(new PerAntennaReceiveSensitivityRange(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding PerAntennaReceiveSensitivityRange to perAntennaReceiveSensitivityRangeList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.perAntennaReceiveSensitivityRangeList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional perAntennaReceiveSensitivityRangeList");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"GeneralDeviceCapabilities misses non optional parameter of type GPIOCapabilities");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type GPIOCapabilities");
        }
        if (binary.get(position)) {
            GeneralDeviceCapabilities generalDeviceCapabilities = this;
            tempLength = generalDeviceCapabilities.gPIOCapabilities.length();
        }
        if (type != null && type.equals(GPIOCapabilities.TYPENUM)) {
            this.gPIOCapabilities = new GPIOCapabilities(binary.subList(position, tempLength));
            position += tempLength;
        } else {
            LOGGER.warn((Object)"GeneralDeviceCapabilities misses non optional parameter of type GPIOCapabilities");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type GPIOCapabilities");
        }
        LOGGER.debug((Object)(" gPIOCapabilities is instantiated with GPIOCapabilities with length" + tempLength));
        this.perAntennaAirProtocolList = new LinkedList<PerAntennaAirProtocol>();
        LOGGER.debug((Object)"decoding parameter perAntennaAirProtocolList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(PerAntennaAirProtocol.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = PerAntennaAirProtocol.length();
                }
                this.perAntennaAirProtocolList.add(new PerAntennaAirProtocol(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding PerAntennaAirProtocol to perAntennaAirProtocolList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.perAntennaAirProtocolList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional perAntennaAirProtocolList");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type PerAntennaAirProtocol");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("MaxNumberOfAntennaSupported", ns);
        if (temp != null) {
            this.maxNumberOfAntennaSupported = new UnsignedShort(temp);
        }
        element.removeChild("MaxNumberOfAntennaSupported", ns);
        temp = element.getChild("CanSetAntennaProperties", ns);
        if (temp != null) {
            this.canSetAntennaProperties = new Bit(temp);
        }
        element.removeChild("CanSetAntennaProperties", ns);
        temp = element.getChild("HasUTCClockCapability", ns);
        if (temp != null) {
            this.hasUTCClockCapability = new Bit(temp);
        }
        element.removeChild("HasUTCClockCapability", ns);
        temp = element.getChild("DeviceManufacturerName", ns);
        if (temp != null) {
            this.deviceManufacturerName = new UnsignedInteger(temp);
        }
        element.removeChild("DeviceManufacturerName", ns);
        temp = element.getChild("ModelName", ns);
        if (temp != null) {
            this.modelName = new UnsignedInteger(temp);
        }
        element.removeChild("ModelName", ns);
        temp = element.getChild("ReaderFirmwareVersion", ns);
        if (temp != null) {
            this.readerFirmwareVersion = new UTF8String_UTF_8(temp);
        }
        element.removeChild("ReaderFirmwareVersion", ns);
        this.receiveSensitivityTableEntryList = new LinkedList<ReceiveSensitivityTableEntry>();
        tempList = element.getChildren("ReceiveSensitivityTableEntry", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"GeneralDeviceCapabilities misses non optional parameter of type receiveSensitivityTableEntryList");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type receiveSensitivityTableEntryList");
        }
        for (Element e : tempList) {
            this.receiveSensitivityTableEntryList.add(new ReceiveSensitivityTableEntry(e));
            LOGGER.debug((Object)"adding ReceiveSensitivityTableEntry to receiveSensitivityTableEntryList ");
        }
        element.removeChildren("ReceiveSensitivityTableEntry", ns);
        this.perAntennaReceiveSensitivityRangeList = new LinkedList<PerAntennaReceiveSensitivityRange>();
        tempList = element.getChildren("PerAntennaReceiveSensitivityRange", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"GeneralDeviceCapabilities misses optional parameter of type perAntennaReceiveSensitivityRangeList");
        } else {
            for (Element e : tempList) {
                this.perAntennaReceiveSensitivityRangeList.add(new PerAntennaReceiveSensitivityRange(e));
                LOGGER.debug((Object)"adding PerAntennaReceiveSensitivityRange to perAntennaReceiveSensitivityRangeList ");
            }
        }
        element.removeChildren("PerAntennaReceiveSensitivityRange", ns);
        temp = element.getChild("GPIOCapabilities", ns);
        if (temp != null) {
            this.gPIOCapabilities = new GPIOCapabilities(temp);
            LOGGER.info((Object)"setting parameter gPIOCapabilities for parameter GeneralDeviceCapabilities");
        }
        if (temp == null) {
            LOGGER.warn((Object)"GeneralDeviceCapabilities misses non optional parameter of type gPIOCapabilities");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type gPIOCapabilities");
        }
        element.removeChild("GPIOCapabilities", ns);
        this.perAntennaAirProtocolList = new LinkedList<PerAntennaAirProtocol>();
        tempList = element.getChildren("PerAntennaAirProtocol", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"GeneralDeviceCapabilities misses non optional parameter of type perAntennaAirProtocolList");
            throw new MissingParameterException("GeneralDeviceCapabilities misses non optional parameter of type perAntennaAirProtocolList");
        }
        for (Element e : tempList) {
            this.perAntennaAirProtocolList.add(new PerAntennaAirProtocol(e));
            LOGGER.debug((Object)"adding PerAntennaAirProtocol to perAntennaAirProtocolList ");
        }
        element.removeChildren("PerAntennaAirProtocol", ns);
        if (element.getChildren().size() > 0) {
            String message = "GeneralDeviceCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setMaxNumberOfAntennaSupported(UnsignedShort maxNumberOfAntennaSupported) {
        this.maxNumberOfAntennaSupported = maxNumberOfAntennaSupported;
    }

    public void setCanSetAntennaProperties(Bit canSetAntennaProperties) {
        this.canSetAntennaProperties = canSetAntennaProperties;
    }

    public void setHasUTCClockCapability(Bit hasUTCClockCapability) {
        this.hasUTCClockCapability = hasUTCClockCapability;
    }

    public void setDeviceManufacturerName(UnsignedInteger deviceManufacturerName) {
        this.deviceManufacturerName = deviceManufacturerName;
    }

    public void setModelName(UnsignedInteger modelName) {
        this.modelName = modelName;
    }

    public void setReaderFirmwareVersion(UTF8String_UTF_8 readerFirmwareVersion) {
        this.readerFirmwareVersion = readerFirmwareVersion;
    }

    public void setReceiveSensitivityTableEntryList(List<ReceiveSensitivityTableEntry> receiveSensitivityTableEntryList) {
        this.receiveSensitivityTableEntryList = receiveSensitivityTableEntryList;
    }

    public void setPerAntennaReceiveSensitivityRangeList(List<PerAntennaReceiveSensitivityRange> perAntennaReceiveSensitivityRangeList) {
        this.perAntennaReceiveSensitivityRangeList = perAntennaReceiveSensitivityRangeList;
    }

    public void setGPIOCapabilities(GPIOCapabilities gPIOCapabilities) {
        this.gPIOCapabilities = gPIOCapabilities;
    }

    public void setPerAntennaAirProtocolList(List<PerAntennaAirProtocol> perAntennaAirProtocolList) {
        this.perAntennaAirProtocolList = perAntennaAirProtocolList;
    }

    public UnsignedShort getMaxNumberOfAntennaSupported() {
        return this.maxNumberOfAntennaSupported;
    }

    public Bit getCanSetAntennaProperties() {
        return this.canSetAntennaProperties;
    }

    public Bit getHasUTCClockCapability() {
        return this.hasUTCClockCapability;
    }

    public UnsignedInteger getDeviceManufacturerName() {
        return this.deviceManufacturerName;
    }

    public UnsignedInteger getModelName() {
        return this.modelName;
    }

    public UTF8String_UTF_8 getReaderFirmwareVersion() {
        return this.readerFirmwareVersion;
    }

    public List<ReceiveSensitivityTableEntry> getReceiveSensitivityTableEntryList() {
        return this.receiveSensitivityTableEntryList;
    }

    public List<PerAntennaReceiveSensitivityRange> getPerAntennaReceiveSensitivityRangeList() {
        return this.perAntennaReceiveSensitivityRangeList;
    }

    public GPIOCapabilities getGPIOCapabilities() {
        return this.gPIOCapabilities;
    }

    public List<PerAntennaAirProtocol> getPerAntennaAirProtocolList() {
        return this.perAntennaAirProtocolList;
    }

    public void addToReceiveSensitivityTableEntryList(ReceiveSensitivityTableEntry receiveSensitivityTableEntry) {
        if (this.receiveSensitivityTableEntryList == null) {
            this.receiveSensitivityTableEntryList = new LinkedList<ReceiveSensitivityTableEntry>();
        }
        this.receiveSensitivityTableEntryList.add(receiveSensitivityTableEntry);
    }

    public void addToPerAntennaReceiveSensitivityRangeList(PerAntennaReceiveSensitivityRange perAntennaReceiveSensitivityRange) {
        if (this.perAntennaReceiveSensitivityRangeList == null) {
            this.perAntennaReceiveSensitivityRangeList = new LinkedList<PerAntennaReceiveSensitivityRange>();
        }
        this.perAntennaReceiveSensitivityRangeList.add(perAntennaReceiveSensitivityRange);
    }

    public void addToPerAntennaAirProtocolList(PerAntennaAirProtocol perAntennaAirProtocol) {
        if (this.perAntennaAirProtocolList == null) {
            this.perAntennaAirProtocolList = new LinkedList<PerAntennaAirProtocol>();
        }
        this.perAntennaAirProtocolList.add(perAntennaAirProtocol);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "GeneralDeviceCapabilities";
    }

    public String toString() {
        String result = "GeneralDeviceCapabilities: ";
        result = result + ", maxNumberOfAntennaSupported: ";
        result = result + this.maxNumberOfAntennaSupported;
        result = result + ", canSetAntennaProperties: ";
        result = result + this.canSetAntennaProperties;
        result = result + ", hasUTCClockCapability: ";
        result = result + this.hasUTCClockCapability;
        result = result + ", deviceManufacturerName: ";
        result = result + this.deviceManufacturerName;
        result = result + ", modelName: ";
        result = result + this.modelName;
        result = result + ", readerFirmwareVersion: ";
        result = result + this.readerFirmwareVersion;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

