/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.IdentificationType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedByteArray_HEX;
import org.llrp.ltk.types.UnsignedShort;

public class Identification
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(218);
    private static final Logger LOGGER = Logger.getLogger(Identification.class);
    protected IdentificationType iDType;
    protected UnsignedByteArray_HEX readerID;

    public Identification() {
    }

    public Identification(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public Identification(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.iDType == null) {
            LOGGER.warn((Object)" iDType not set");
            throw new MissingParameterException(" iDType not set  for Parameter of Type Identification");
        }
        resultBits.append(this.iDType.encodeBinary());
        if (this.readerID == null) {
            LOGGER.warn((Object)" readerID not set");
            throw new MissingParameterException(" readerID not set  for Parameter of Type Identification");
        }
        resultBits.append(this.readerID.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.iDType == null) {
            LOGGER.warn((Object)" iDType not set");
            throw new MissingParameterException(" iDType not set");
        }
        element.addContent(this.iDType.encodeXML("IDType", ns));
        if (this.readerID == null) {
            LOGGER.warn((Object)" readerID not set");
            throw new MissingParameterException(" readerID not set");
        }
        element.addContent(this.readerID.encodeXML("ReaderID", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.iDType = new IdentificationType(binary.subList(position, IdentificationType.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += IdentificationType.length(), UnsignedShort.length())).toShort();
        tempLength = UnsignedByteArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.readerID = new UnsignedByteArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UnsignedByteArray_HEX with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for readerID ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("IDType", ns);
        if (temp != null) {
            this.iDType = new IdentificationType(temp);
        }
        element.removeChild("IDType", ns);
        temp = element.getChild("ReaderID", ns);
        if (temp != null) {
            this.readerID = new UnsignedByteArray_HEX(temp);
        }
        element.removeChild("ReaderID", ns);
        if (element.getChildren().size() > 0) {
            String message = "Identification has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setIDType(IdentificationType iDType) {
        this.iDType = iDType;
    }

    public void setReaderID(UnsignedByteArray_HEX readerID) {
        this.readerID = readerID;
    }

    public IdentificationType getIDType() {
        return this.iDType;
    }

    public UnsignedByteArray_HEX getReaderID() {
        return this.readerID;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "Identification";
    }

    public String toString() {
        String result = "Identification: ";
        result = result + ", iDType: ";
        result = result + this.iDType;
        result = result + ", readerID: ";
        result = result + this.readerID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

