/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.AirProtocols;
import org.llrp.ltk.generated.parameters.AntennaConfiguration;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryParameterSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(186);
    private static final Logger LOGGER = Logger.getLogger(InventoryParameterSpec.class);
    protected UnsignedShort inventoryParameterSpecID;
    protected AirProtocols protocolID;
    protected List<AntennaConfiguration> antennaConfigurationList = new LinkedList<AntennaConfiguration>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public InventoryParameterSpec() {
    }

    public InventoryParameterSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public InventoryParameterSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.inventoryParameterSpecID == null) {
            LOGGER.warn((Object)" inventoryParameterSpecID not set");
            throw new MissingParameterException(" inventoryParameterSpecID not set  for Parameter of Type InventoryParameterSpec");
        }
        resultBits.append(this.inventoryParameterSpecID.encodeBinary());
        if (this.protocolID == null) {
            LOGGER.warn((Object)" protocolID not set");
            throw new MissingParameterException(" protocolID not set  for Parameter of Type InventoryParameterSpec");
        }
        resultBits.append(this.protocolID.encodeBinary());
        if (this.antennaConfigurationList == null) {
            LOGGER.info((Object)" antennaConfigurationList not set");
        } else {
            for (AntennaConfiguration antennaConfiguration : this.antennaConfigurationList) {
                resultBits.append(antennaConfiguration.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.inventoryParameterSpecID == null) {
            LOGGER.warn((Object)" inventoryParameterSpecID not set");
            throw new MissingParameterException(" inventoryParameterSpecID not set");
        }
        element.addContent(this.inventoryParameterSpecID.encodeXML("InventoryParameterSpecID", ns));
        if (this.protocolID == null) {
            LOGGER.warn((Object)" protocolID not set");
            throw new MissingParameterException(" protocolID not set");
        }
        element.addContent(this.protocolID.encodeXML("ProtocolID", ns));
        if (this.antennaConfigurationList == null) {
            LOGGER.info((Object)"antennaConfigurationList not set");
        } else {
            for (AntennaConfiguration antennaConfiguration : this.antennaConfigurationList) {
                element.addContent(antennaConfiguration.encodeXML(antennaConfiguration.getClass().getName().replaceAll(antennaConfiguration.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.inventoryParameterSpecID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.protocolID = new AirProtocols(binary.subList(position += UnsignedShort.length(), AirProtocols.length()));
        position += AirProtocols.length();
        this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
        LOGGER.debug((Object)"decoding parameter antennaConfigurationList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(AntennaConfiguration.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = AntennaConfiguration.length();
                }
                this.antennaConfigurationList.add(new AntennaConfiguration(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding AntennaConfiguration to antennaConfigurationList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.antennaConfigurationList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional antennaConfigurationList");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("InventoryParameterSpecID", ns);
        if (temp != null) {
            this.inventoryParameterSpecID = new UnsignedShort(temp);
        }
        element.removeChild("InventoryParameterSpecID", ns);
        temp = element.getChild("ProtocolID", ns);
        if (temp != null) {
            this.protocolID = new AirProtocols(temp);
        }
        element.removeChild("ProtocolID", ns);
        this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
        tempList = element.getChildren("AntennaConfiguration", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"InventoryParameterSpec misses optional parameter of type antennaConfigurationList");
        } else {
            for (Element e : tempList) {
                this.antennaConfigurationList.add(new AntennaConfiguration(e));
                LOGGER.debug((Object)"adding AntennaConfiguration to antennaConfigurationList ");
            }
        }
        element.removeChildren("AntennaConfiguration", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"InventoryParameterSpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "InventoryParameterSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setInventoryParameterSpecID(UnsignedShort inventoryParameterSpecID) {
        this.inventoryParameterSpecID = inventoryParameterSpecID;
    }

    public void setProtocolID(AirProtocols protocolID) {
        this.protocolID = protocolID;
    }

    public void setAntennaConfigurationList(List<AntennaConfiguration> antennaConfigurationList) {
        this.antennaConfigurationList = antennaConfigurationList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getInventoryParameterSpecID() {
        return this.inventoryParameterSpecID;
    }

    public AirProtocols getProtocolID() {
        return this.protocolID;
    }

    public List<AntennaConfiguration> getAntennaConfigurationList() {
        return this.antennaConfigurationList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToAntennaConfigurationList(AntennaConfiguration antennaConfiguration) {
        if (this.antennaConfigurationList == null) {
            this.antennaConfigurationList = new LinkedList<AntennaConfiguration>();
        }
        this.antennaConfigurationList.add(antennaConfiguration);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "InventoryParameterSpec";
    }

    public String toString() {
        String result = "InventoryParameterSpec: ";
        result = result + ", inventoryParameterSpecID: ";
        result = result + this.inventoryParameterSpecID;
        result = result + ", protocolID: ";
        result = result + this.protocolID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

