/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.StatusCode;
import org.llrp.ltk.generated.parameters.FieldError;
import org.llrp.ltk.generated.parameters.ParameterError;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UTF8String_UTF_8;
import org.llrp.ltk.types.UnsignedShort;

public class LLRPStatus
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(287);
    private static final Logger LOGGER = Logger.getLogger(LLRPStatus.class);
    protected StatusCode statusCode;
    protected UTF8String_UTF_8 errorDescription;
    protected FieldError fieldError;
    protected ParameterError parameterError;

    public LLRPStatus() {
    }

    public LLRPStatus(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public LLRPStatus(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.statusCode == null) {
            LOGGER.warn((Object)" statusCode not set");
            throw new MissingParameterException(" statusCode not set  for Parameter of Type LLRPStatus");
        }
        resultBits.append(this.statusCode.encodeBinary());
        if (this.errorDescription == null) {
            LOGGER.warn((Object)" errorDescription not set");
            throw new MissingParameterException(" errorDescription not set  for Parameter of Type LLRPStatus");
        }
        resultBits.append(this.errorDescription.encodeBinary());
        if (this.fieldError == null) {
            LOGGER.info((Object)" fieldError not set");
        } else {
            resultBits.append(this.fieldError.encodeBinary());
        }
        if (this.parameterError == null) {
            LOGGER.info((Object)" parameterError not set");
        } else {
            resultBits.append(this.parameterError.encodeBinary());
        }
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.statusCode == null) {
            LOGGER.warn((Object)" statusCode not set");
            throw new MissingParameterException(" statusCode not set");
        }
        element.addContent(this.statusCode.encodeXML("StatusCode", ns));
        if (this.errorDescription == null) {
            LOGGER.warn((Object)" errorDescription not set");
            throw new MissingParameterException(" errorDescription not set");
        }
        element.addContent(this.errorDescription.encodeXML("ErrorDescription", ns));
        if (this.fieldError == null) {
            LOGGER.info((Object)"fieldError not set");
        } else {
            element.addContent(this.fieldError.encodeXML(this.fieldError.getClass().getSimpleName(), ns));
        }
        if (this.parameterError == null) {
            LOGGER.info((Object)"parameterError not set");
        } else {
            element.addContent(this.parameterError.encodeXML(this.parameterError.getClass().getSimpleName(), ns));
        }
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.statusCode = new StatusCode(binary.subList(position, StatusCode.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += StatusCode.length(), UnsignedShort.length())).toShort();
        tempLength = UTF8String_UTF_8.length() * fieldCount + UnsignedShort.length();
        this.errorDescription = new UTF8String_UTF_8(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: UTF8String_UTF_8 with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for errorDescription ");
        }
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type FieldError");
        }
        if (binary.get(position)) {
            LLRPStatus lLRPStatus = this;
            tempLength = lLRPStatus.fieldError.length();
        }
        if (type != null && type.equals(FieldError.TYPENUM)) {
            this.fieldError = new FieldError(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" fieldError is instantiated with FieldError with length" + tempLength));
        } else {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type FieldError");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type ParameterError");
        }
        if (binary.get(position)) {
            LLRPStatus lLRPStatus = this;
            tempLength = lLRPStatus.parameterError.length();
        }
        if (type != null && type.equals(ParameterError.TYPENUM)) {
            this.parameterError = new ParameterError(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" parameterError is instantiated with ParameterError with length" + tempLength));
        } else {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type ParameterError");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("StatusCode", ns);
        if (temp != null) {
            this.statusCode = new StatusCode(temp);
        }
        element.removeChild("StatusCode", ns);
        temp = element.getChild("ErrorDescription", ns);
        if (temp != null) {
            this.errorDescription = new UTF8String_UTF_8(temp);
        }
        element.removeChild("ErrorDescription", ns);
        temp = element.getChild("FieldError", ns);
        if (temp != null) {
            this.fieldError = new FieldError(temp);
            LOGGER.info((Object)"setting parameter fieldError for parameter LLRPStatus");
        }
        if (temp == null) {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type fieldError");
        }
        element.removeChild("FieldError", ns);
        temp = element.getChild("ParameterError", ns);
        if (temp != null) {
            this.parameterError = new ParameterError(temp);
            LOGGER.info((Object)"setting parameter parameterError for parameter LLRPStatus");
        }
        if (temp == null) {
            LOGGER.info((Object)"LLRPStatus misses optional parameter of type parameterError");
        }
        element.removeChild("ParameterError", ns);
        if (element.getChildren().size() > 0) {
            String message = "LLRPStatus has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public void setErrorDescription(UTF8String_UTF_8 errorDescription) {
        this.errorDescription = errorDescription;
    }

    public void setFieldError(FieldError fieldError) {
        this.fieldError = fieldError;
    }

    public void setParameterError(ParameterError parameterError) {
        this.parameterError = parameterError;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public UTF8String_UTF_8 getErrorDescription() {
        return this.errorDescription;
    }

    public FieldError getFieldError() {
        return this.fieldError;
    }

    public ParameterError getParameterError() {
        return this.parameterError;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "LLRPStatus";
    }

    public String toString() {
        String result = "LLRPStatus: ";
        result = result + ", statusCode: ";
        result = result + this.statusCode;
        result = result + ", errorDescription: ";
        result = result + this.errorDescription;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

