/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.StatusCode;
import org.llrp.ltk.generated.parameters.FieldError;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class ParameterError
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(289);
    private static final Logger LOGGER = Logger.getLogger(ParameterError.class);
    protected UnsignedShort parameterType;
    protected StatusCode errorCode;
    protected FieldError fieldError;
    protected ParameterError parameterError;

    public ParameterError() {
    }

    public ParameterError(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ParameterError(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.parameterType == null) {
            LOGGER.warn((Object)" parameterType not set");
            throw new MissingParameterException(" parameterType not set  for Parameter of Type ParameterError");
        }
        resultBits.append(this.parameterType.encodeBinary());
        if (this.errorCode == null) {
            LOGGER.warn((Object)" errorCode not set");
            throw new MissingParameterException(" errorCode not set  for Parameter of Type ParameterError");
        }
        resultBits.append(this.errorCode.encodeBinary());
        if (this.fieldError == null) {
            LOGGER.info((Object)" fieldError not set");
        } else {
            resultBits.append(this.fieldError.encodeBinary());
        }
        if (this.parameterError == null) {
            LOGGER.info((Object)" parameterError not set");
        } else {
            resultBits.append(this.parameterError.encodeBinary());
        }
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.parameterType == null) {
            LOGGER.warn((Object)" parameterType not set");
            throw new MissingParameterException(" parameterType not set");
        }
        element.addContent(this.parameterType.encodeXML("ParameterType", ns));
        if (this.errorCode == null) {
            LOGGER.warn((Object)" errorCode not set");
            throw new MissingParameterException(" errorCode not set");
        }
        element.addContent(this.errorCode.encodeXML("ErrorCode", ns));
        if (this.fieldError == null) {
            LOGGER.info((Object)"fieldError not set");
        } else {
            element.addContent(this.fieldError.encodeXML(this.fieldError.getClass().getSimpleName(), ns));
        }
        if (this.parameterError == null) {
            LOGGER.info((Object)"parameterError not set");
        } else {
            element.addContent(this.parameterError.encodeXML(this.parameterError.getClass().getSimpleName(), ns));
        }
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.parameterType = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.errorCode = new StatusCode(binary.subList(position += UnsignedShort.length(), StatusCode.length()));
        position += StatusCode.length();
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"ParameterError misses optional parameter of type FieldError");
        }
        if (binary.get(position)) {
            ParameterError parameterError = this;
            tempLength = parameterError.fieldError.length();
        }
        if (type != null && type.equals(FieldError.TYPENUM)) {
            this.fieldError = new FieldError(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" fieldError is instantiated with FieldError with length" + tempLength));
        } else {
            LOGGER.info((Object)"ParameterError misses optional parameter of type FieldError");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"ParameterError misses optional parameter of type ParameterError");
        }
        if (binary.get(position)) {
            ParameterError parameterError = this;
            tempLength = parameterError.parameterError.length();
        }
        if (type != null && type.equals(TYPENUM)) {
            this.parameterError = new ParameterError(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" parameterError is instantiated with ParameterError with length" + tempLength));
        } else {
            LOGGER.info((Object)"ParameterError misses optional parameter of type ParameterError");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ParameterType", ns);
        if (temp != null) {
            this.parameterType = new UnsignedShort(temp);
        }
        element.removeChild("ParameterType", ns);
        temp = element.getChild("ErrorCode", ns);
        if (temp != null) {
            this.errorCode = new StatusCode(temp);
        }
        element.removeChild("ErrorCode", ns);
        temp = element.getChild("FieldError", ns);
        if (temp != null) {
            this.fieldError = new FieldError(temp);
            LOGGER.info((Object)"setting parameter fieldError for parameter ParameterError");
        }
        if (temp == null) {
            LOGGER.info((Object)"ParameterError misses optional parameter of type fieldError");
        }
        element.removeChild("FieldError", ns);
        temp = element.getChild("ParameterError", ns);
        if (temp != null) {
            this.parameterError = new ParameterError(temp);
            LOGGER.info((Object)"setting parameter parameterError for parameter ParameterError");
        }
        if (temp == null) {
            LOGGER.info((Object)"ParameterError misses optional parameter of type parameterError");
        }
        element.removeChild("ParameterError", ns);
        if (element.getChildren().size() > 0) {
            String message = "ParameterError has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setParameterType(UnsignedShort parameterType) {
        this.parameterType = parameterType;
    }

    public void setErrorCode(StatusCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setFieldError(FieldError fieldError) {
        this.fieldError = fieldError;
    }

    public void setParameterError(ParameterError parameterError) {
        this.parameterError = parameterError;
    }

    public UnsignedShort getParameterType() {
        return this.parameterType;
    }

    public StatusCode getErrorCode() {
        return this.errorCode;
    }

    public FieldError getFieldError() {
        return this.fieldError;
    }

    public ParameterError getParameterError() {
        return this.parameterError;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "ParameterError";
    }

    public String toString() {
        String result = "ParameterError: ";
        result = result + ", parameterType: ";
        result = result + this.parameterType;
        result = result + ", errorCode: ";
        result = result + this.errorCode;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

