/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.AirProtocolsArray;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class PerAntennaAirProtocol
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(140);
    private static final Logger LOGGER = Logger.getLogger(PerAntennaAirProtocol.class);
    protected UnsignedShort antennaID;
    protected AirProtocolsArray protocolID;

    public PerAntennaAirProtocol() {
    }

    public PerAntennaAirProtocol(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public PerAntennaAirProtocol(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type PerAntennaAirProtocol");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.protocolID == null) {
            LOGGER.warn((Object)" protocolID not set");
            throw new MissingParameterException(" protocolID not set  for Parameter of Type PerAntennaAirProtocol");
        }
        resultBits.append(this.protocolID.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.antennaID == null) {
            LOGGER.warn((Object)" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.protocolID == null) {
            LOGGER.warn((Object)" protocolID not set");
            throw new MissingParameterException(" protocolID not set");
        }
        element.addContent(this.protocolID.encodeXML("ProtocolID", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.antennaID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        short fieldCount = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length())).toShort();
        tempLength = AirProtocolsArray.length() * fieldCount + UnsignedShort.length();
        this.protocolID = new AirProtocolsArray(binary.subList(position, tempLength));
        position += tempLength;
        LOGGER.debug((Object)("decoding array of type: AirProtocolsArray with " + tempLength + " length"));
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
            LOGGER.info((Object)"padding needed for protocolID ");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("ProtocolID", ns);
        if (temp != null) {
            this.protocolID = new AirProtocolsArray(temp);
        }
        element.removeChild("ProtocolID", ns);
        if (element.getChildren().size() > 0) {
            String message = "PerAntennaAirProtocol has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setProtocolID(AirProtocolsArray protocolID) {
        this.protocolID = protocolID;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public AirProtocolsArray getProtocolID() {
        return this.protocolID;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "PerAntennaAirProtocol";
    }

    public String toString() {
        String result = "PerAntennaAirProtocol: ";
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result + ", protocolID: ";
        result = result + this.protocolID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

