/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.UTCTimestamp;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class PeriodicTriggerValue
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(180);
    private static final Logger LOGGER = Logger.getLogger(PeriodicTriggerValue.class);
    protected UnsignedInteger offset;
    protected UnsignedInteger period;
    protected UTCTimestamp uTCTimestamp;

    public PeriodicTriggerValue() {
    }

    public PeriodicTriggerValue(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public PeriodicTriggerValue(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.offset == null) {
            LOGGER.warn((Object)" offset not set");
            throw new MissingParameterException(" offset not set  for Parameter of Type PeriodicTriggerValue");
        }
        resultBits.append(this.offset.encodeBinary());
        if (this.period == null) {
            LOGGER.warn((Object)" period not set");
            throw new MissingParameterException(" period not set  for Parameter of Type PeriodicTriggerValue");
        }
        resultBits.append(this.period.encodeBinary());
        if (this.uTCTimestamp == null) {
            LOGGER.info((Object)" uTCTimestamp not set");
        } else {
            resultBits.append(this.uTCTimestamp.encodeBinary());
        }
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.offset == null) {
            LOGGER.warn((Object)" offset not set");
            throw new MissingParameterException(" offset not set");
        }
        element.addContent(this.offset.encodeXML("Offset", ns));
        if (this.period == null) {
            LOGGER.warn((Object)" period not set");
            throw new MissingParameterException(" period not set");
        }
        element.addContent(this.period.encodeXML("Period", ns));
        if (this.uTCTimestamp == null) {
            LOGGER.info((Object)"uTCTimestamp not set");
        } else {
            element.addContent(this.uTCTimestamp.encodeXML(this.uTCTimestamp.getClass().getSimpleName(), ns));
        }
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.offset = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.period = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"PeriodicTriggerValue misses optional parameter of type UTCTimestamp");
        }
        if (binary.get(position)) {
            PeriodicTriggerValue periodicTriggerValue = this;
            tempLength = periodicTriggerValue.uTCTimestamp.length();
        }
        if (type != null && type.equals(UTCTimestamp.TYPENUM)) {
            this.uTCTimestamp = new UTCTimestamp(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" uTCTimestamp is instantiated with UTCTimestamp with length" + tempLength));
        } else {
            LOGGER.info((Object)"PeriodicTriggerValue misses optional parameter of type UTCTimestamp");
        }
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Offset", ns);
        if (temp != null) {
            this.offset = new UnsignedInteger(temp);
        }
        element.removeChild("Offset", ns);
        temp = element.getChild("Period", ns);
        if (temp != null) {
            this.period = new UnsignedInteger(temp);
        }
        element.removeChild("Period", ns);
        temp = element.getChild("UTCTimestamp", ns);
        if (temp != null) {
            this.uTCTimestamp = new UTCTimestamp(temp);
            LOGGER.info((Object)"setting parameter uTCTimestamp for parameter PeriodicTriggerValue");
        }
        if (temp == null) {
            LOGGER.info((Object)"PeriodicTriggerValue misses optional parameter of type uTCTimestamp");
        }
        element.removeChild("UTCTimestamp", ns);
        if (element.getChildren().size() > 0) {
            String message = "PeriodicTriggerValue has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setOffset(UnsignedInteger offset) {
        this.offset = offset;
    }

    public void setPeriod(UnsignedInteger period) {
        this.period = period;
    }

    public void setUTCTimestamp(UTCTimestamp uTCTimestamp) {
        this.uTCTimestamp = uTCTimestamp;
    }

    public UnsignedInteger getOffset() {
        return this.offset;
    }

    public UnsignedInteger getPeriod() {
        return this.period;
    }

    public UTCTimestamp getUTCTimestamp() {
        return this.uTCTimestamp;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "PeriodicTriggerValue";
    }

    public String toString() {
        String result = "PeriodicTriggerValue: ";
        result = result + ", offset: ";
        result = result + this.offset;
        result = result + ", period: ";
        result = result + this.period;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

