/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.FrequencyRSSILevelEntry;
import org.llrp.ltk.generated.parameters.ROSpecID;
import org.llrp.ltk.generated.parameters.SpecIndex;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFSurveyReportData
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(242);
    private static final Logger LOGGER = Logger.getLogger(RFSurveyReportData.class);
    protected ROSpecID rOSpecID;
    protected SpecIndex specIndex;
    protected List<FrequencyRSSILevelEntry> frequencyRSSILevelEntryList = new LinkedList<FrequencyRSSILevelEntry>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public RFSurveyReportData() {
    }

    public RFSurveyReportData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RFSurveyReportData(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpecID == null) {
            LOGGER.info((Object)" rOSpecID not set");
        } else {
            resultBits.append(this.rOSpecID.encodeBinary());
        }
        if (this.specIndex == null) {
            LOGGER.info((Object)" specIndex not set");
        } else {
            resultBits.append(this.specIndex.encodeBinary());
        }
        if (this.frequencyRSSILevelEntryList == null) {
            LOGGER.warn((Object)" frequencyRSSILevelEntryList not set");
            throw new MissingParameterException(" frequencyRSSILevelEntryList not set");
        }
        for (FrequencyRSSILevelEntry frequencyRSSILevelEntry : this.frequencyRSSILevelEntryList) {
            resultBits.append(frequencyRSSILevelEntry.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.rOSpecID == null) {
            LOGGER.info((Object)"rOSpecID not set");
        } else {
            element.addContent(this.rOSpecID.encodeXML(this.rOSpecID.getClass().getSimpleName(), ns));
        }
        if (this.specIndex == null) {
            LOGGER.info((Object)"specIndex not set");
        } else {
            element.addContent(this.specIndex.encodeXML(this.specIndex.getClass().getSimpleName(), ns));
        }
        if (this.frequencyRSSILevelEntryList == null) {
            LOGGER.warn((Object)" frequencyRSSILevelEntryList not set");
            throw new MissingParameterException("  frequencyRSSILevelEntryList not set");
        }
        for (FrequencyRSSILevelEntry frequencyRSSILevelEntry : this.frequencyRSSILevelEntryList) {
            element.addContent(frequencyRSSILevelEntry.encodeXML(frequencyRSSILevelEntry.getClass().getName().replaceAll(frequencyRSSILevelEntry.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        LLRPNumberType type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type ROSpecID");
        }
        if (binary.get(position)) {
            RFSurveyReportData rFSurveyReportData = this;
            tempLength = rFSurveyReportData.rOSpecID.length();
        }
        if (type != null && type.equals(ROSpecID.TYPENUM)) {
            this.rOSpecID = new ROSpecID(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" rOSpecID is instantiated with ROSpecID with length" + tempLength));
        } else {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type ROSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type SpecIndex");
        }
        if (binary.get(position)) {
            RFSurveyReportData rFSurveyReportData = this;
            tempLength = rFSurveyReportData.specIndex.length();
        }
        if (type != null && type.equals(SpecIndex.TYPENUM)) {
            this.specIndex = new SpecIndex(binary.subList(position, tempLength));
            position += tempLength;
            LOGGER.debug((Object)(" specIndex is instantiated with SpecIndex with length" + tempLength));
        } else {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type SpecIndex");
        }
        this.frequencyRSSILevelEntryList = new LinkedList<FrequencyRSSILevelEntry>();
        LOGGER.debug((Object)"decoding parameter frequencyRSSILevelEntryList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(FrequencyRSSILevelEntry.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = FrequencyRSSILevelEntry.length();
                }
                this.frequencyRSSILevelEntryList.add(new FrequencyRSSILevelEntry(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding FrequencyRSSILevelEntry to frequencyRSSILevelEntryList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.frequencyRSSILevelEntryList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional frequencyRSSILevelEntryList");
            throw new MissingParameterException("RFSurveyReportData misses non optional parameter of type FrequencyRSSILevelEntry");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new ROSpecID(temp);
            LOGGER.info((Object)"setting parameter rOSpecID for parameter RFSurveyReportData");
        }
        if (temp == null) {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type rOSpecID");
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new SpecIndex(temp);
            LOGGER.info((Object)"setting parameter specIndex for parameter RFSurveyReportData");
        }
        if (temp == null) {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type specIndex");
        }
        element.removeChild("SpecIndex", ns);
        this.frequencyRSSILevelEntryList = new LinkedList<FrequencyRSSILevelEntry>();
        tempList = element.getChildren("FrequencyRSSILevelEntry", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"RFSurveyReportData misses non optional parameter of type frequencyRSSILevelEntryList");
            throw new MissingParameterException("RFSurveyReportData misses non optional parameter of type frequencyRSSILevelEntryList");
        }
        for (Element e : tempList) {
            this.frequencyRSSILevelEntryList.add(new FrequencyRSSILevelEntry(e));
            LOGGER.debug((Object)"adding FrequencyRSSILevelEntry to frequencyRSSILevelEntryList ");
        }
        element.removeChildren("FrequencyRSSILevelEntry", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"RFSurveyReportData misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "RFSurveyReportData has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROSpecID(ROSpecID rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setSpecIndex(SpecIndex specIndex) {
        this.specIndex = specIndex;
    }

    public void setFrequencyRSSILevelEntryList(List<FrequencyRSSILevelEntry> frequencyRSSILevelEntryList) {
        this.frequencyRSSILevelEntryList = frequencyRSSILevelEntryList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ROSpecID getROSpecID() {
        return this.rOSpecID;
    }

    public SpecIndex getSpecIndex() {
        return this.specIndex;
    }

    public List<FrequencyRSSILevelEntry> getFrequencyRSSILevelEntryList() {
        return this.frequencyRSSILevelEntryList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToFrequencyRSSILevelEntryList(FrequencyRSSILevelEntry frequencyRSSILevelEntry) {
        if (this.frequencyRSSILevelEntryList == null) {
            this.frequencyRSSILevelEntryList = new LinkedList<FrequencyRSSILevelEntry>();
        }
        this.frequencyRSSILevelEntryList.add(frequencyRSSILevelEntry);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "RFSurveyReportData";
    }

    public String toString() {
        String result = "RFSurveyReportData: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

