/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class RFTransmitter
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(224);
    private static final Logger LOGGER = Logger.getLogger(RFTransmitter.class);
    protected UnsignedShort hopTableID;
    protected UnsignedShort channelIndex;
    protected UnsignedShort transmitPower;

    public RFTransmitter() {
    }

    public RFTransmitter(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RFTransmitter(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.hopTableID == null) {
            LOGGER.warn((Object)" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set  for Parameter of Type RFTransmitter");
        }
        resultBits.append(this.hopTableID.encodeBinary());
        if (this.channelIndex == null) {
            LOGGER.warn((Object)" channelIndex not set");
            throw new MissingParameterException(" channelIndex not set  for Parameter of Type RFTransmitter");
        }
        resultBits.append(this.channelIndex.encodeBinary());
        if (this.transmitPower == null) {
            LOGGER.warn((Object)" transmitPower not set");
            throw new MissingParameterException(" transmitPower not set  for Parameter of Type RFTransmitter");
        }
        resultBits.append(this.transmitPower.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.hopTableID == null) {
            LOGGER.warn((Object)" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set");
        }
        element.addContent(this.hopTableID.encodeXML("HopTableID", ns));
        if (this.channelIndex == null) {
            LOGGER.warn((Object)" channelIndex not set");
            throw new MissingParameterException(" channelIndex not set");
        }
        element.addContent(this.channelIndex.encodeXML("ChannelIndex", ns));
        if (this.transmitPower == null) {
            LOGGER.warn((Object)" transmitPower not set");
            throw new MissingParameterException(" transmitPower not set");
        }
        element.addContent(this.transmitPower.encodeXML("TransmitPower", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.hopTableID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.channelIndex = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        this.transmitPower = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("HopTableID", ns);
        if (temp != null) {
            this.hopTableID = new UnsignedShort(temp);
        }
        element.removeChild("HopTableID", ns);
        temp = element.getChild("ChannelIndex", ns);
        if (temp != null) {
            this.channelIndex = new UnsignedShort(temp);
        }
        element.removeChild("ChannelIndex", ns);
        temp = element.getChild("TransmitPower", ns);
        if (temp != null) {
            this.transmitPower = new UnsignedShort(temp);
        }
        element.removeChild("TransmitPower", ns);
        if (element.getChildren().size() > 0) {
            String message = "RFTransmitter has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setHopTableID(UnsignedShort hopTableID) {
        this.hopTableID = hopTableID;
    }

    public void setChannelIndex(UnsignedShort channelIndex) {
        this.channelIndex = channelIndex;
    }

    public void setTransmitPower(UnsignedShort transmitPower) {
        this.transmitPower = transmitPower;
    }

    public UnsignedShort getHopTableID() {
        return this.hopTableID;
    }

    public UnsignedShort getChannelIndex() {
        return this.channelIndex;
    }

    public UnsignedShort getTransmitPower() {
        return this.transmitPower;
    }

    public static Integer length() {
        return 0;
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "RFTransmitter";
    }

    public String toString() {
        String result = "RFTransmitter: ";
        result = result + ", hopTableID: ";
        result = result + this.hopTableID;
        result = result + ", channelIndex: ";
        result = result + this.channelIndex;
        result = result + ", transmitPower: ";
        result = result + this.transmitPower;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

