/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.ROReportTriggerType;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.TagReportContentSelector;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROReportSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(237);
    private static final Logger LOGGER = Logger.getLogger(ROReportSpec.class);
    protected ROReportTriggerType rOReportTrigger;
    protected UnsignedShort n;
    protected TagReportContentSelector tagReportContentSelector;
    protected List<Custom> customList = new LinkedList<Custom>();

    public ROReportSpec() {
    }

    public ROReportSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROReportSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOReportTrigger == null) {
            LOGGER.warn((Object)" rOReportTrigger not set");
            throw new MissingParameterException(" rOReportTrigger not set  for Parameter of Type ROReportSpec");
        }
        resultBits.append(this.rOReportTrigger.encodeBinary());
        if (this.n == null) {
            LOGGER.warn((Object)" n not set");
            throw new MissingParameterException(" n not set  for Parameter of Type ROReportSpec");
        }
        resultBits.append(this.n.encodeBinary());
        if (this.tagReportContentSelector == null) {
            LOGGER.warn((Object)" tagReportContentSelector not set");
            throw new MissingParameterException(" tagReportContentSelector not set");
        }
        resultBits.append(this.tagReportContentSelector.encodeBinary());
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.rOReportTrigger == null) {
            LOGGER.warn((Object)" rOReportTrigger not set");
            throw new MissingParameterException(" rOReportTrigger not set");
        }
        element.addContent(this.rOReportTrigger.encodeXML("ROReportTrigger", ns));
        if (this.n == null) {
            LOGGER.warn((Object)" n not set");
            throw new MissingParameterException(" n not set");
        }
        element.addContent(this.n.encodeXML("N", ns));
        if (this.tagReportContentSelector == null) {
            LOGGER.info((Object)"tagReportContentSelector not set");
            throw new MissingParameterException("tagReportContentSelector not set");
        }
        element.addContent(this.tagReportContentSelector.encodeXML(this.tagReportContentSelector.getClass().getSimpleName(), ns));
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.rOReportTrigger = new ROReportTriggerType(binary.subList(position, ROReportTriggerType.length()));
        this.n = new UnsignedShort(binary.subList(position += ROReportTriggerType.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"ROReportSpec misses non optional parameter of type TagReportContentSelector");
            throw new MissingParameterException("ROReportSpec misses non optional parameter of type TagReportContentSelector");
        }
        if (binary.get(position)) {
            ROReportSpec rOReportSpec = this;
            tempLength = rOReportSpec.tagReportContentSelector.length();
        }
        if (type != null && type.equals(TagReportContentSelector.TYPENUM)) {
            this.tagReportContentSelector = new TagReportContentSelector(binary.subList(position, tempLength));
            position += tempLength;
        } else {
            LOGGER.warn((Object)"ROReportSpec misses non optional parameter of type TagReportContentSelector");
            throw new MissingParameterException("ROReportSpec misses non optional parameter of type TagReportContentSelector");
        }
        LOGGER.debug((Object)(" tagReportContentSelector is instantiated with TagReportContentSelector with length" + tempLength));
        this.customList = new LinkedList<Custom>();
        LOGGER.debug((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary.subList(position, tempLength));
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.info((Object)"encoded message does not contain parameter for optional customList");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROReportTrigger", ns);
        if (temp != null) {
            this.rOReportTrigger = new ROReportTriggerType(temp);
        }
        element.removeChild("ROReportTrigger", ns);
        temp = element.getChild("N", ns);
        if (temp != null) {
            this.n = new UnsignedShort(temp);
        }
        element.removeChild("N", ns);
        temp = element.getChild("TagReportContentSelector", ns);
        if (temp != null) {
            this.tagReportContentSelector = new TagReportContentSelector(temp);
            LOGGER.info((Object)"setting parameter tagReportContentSelector for parameter ROReportSpec");
        }
        if (temp == null) {
            LOGGER.warn((Object)"ROReportSpec misses non optional parameter of type tagReportContentSelector");
            throw new MissingParameterException("ROReportSpec misses non optional parameter of type tagReportContentSelector");
        }
        element.removeChild("TagReportContentSelector", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.info((Object)"ROReportSpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROReportSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROReportTrigger(ROReportTriggerType rOReportTrigger) {
        this.rOReportTrigger = rOReportTrigger;
    }

    public void setN(UnsignedShort n) {
        this.n = n;
    }

    public void setTagReportContentSelector(TagReportContentSelector tagReportContentSelector) {
        this.tagReportContentSelector = tagReportContentSelector;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ROReportTriggerType getROReportTrigger() {
        return this.rOReportTrigger;
    }

    public UnsignedShort getN() {
        return this.n;
    }

    public TagReportContentSelector getTagReportContentSelector() {
        return this.tagReportContentSelector;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROReportSpec";
    }

    public String toString() {
        String result = "ROReportSpec: ";
        result = result + ", rOReportTrigger: ";
        result = result + this.rOReportTrigger;
        result = result + ", n: ";
        result = result + this.n;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

