/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class SpecIndex
extends TVParameter {
    public static final SignedShort TYPENUM = new SignedShort(14);
    private static final Logger LOGGER = Logger.getLogger(SpecIndex.class);
    protected UnsignedShort specIndex;

    public SpecIndex() {
    }

    public SpecIndex(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public SpecIndex(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set  for Parameter of Type SpecIndex");
        }
        resultBits.append(this.specIndex.encodeBinary());
        return resultBits;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set");
        }
        element.addContent(this.specIndex.encodeXML("SpecIndex", ns));
        return element;
    }

    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.specIndex = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        position += UnsignedShort.length();
    }

    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new UnsignedShort(temp);
        }
        element.removeChild("SpecIndex", ns);
        if (element.getChildren().size() > 0) {
            String message = "SpecIndex has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setSpecIndex(UnsignedShort specIndex) {
        this.specIndex = specIndex;
    }

    public UnsignedShort getSpecIndex() {
        return this.specIndex;
    }

    public static Integer length() {
        int tempLength = 8;
        return tempLength += UnsignedShort.length();
    }

    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    public String getName() {
        return "SpecIndex";
    }

    public String toString() {
        String result = "SpecIndex: ";
        result = result + ", specIndex: ";
        result = result + this.specIndex;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

