/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AirProtocolUHFRFModeTable;
import org.llrp.ltk.generated.parameters.C1G2UHFRFModeTable;
import org.llrp.ltk.generated.parameters.FrequencyInformation;
import org.llrp.ltk.generated.parameters.TransmitPowerLevelTableEntry;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UHFBandCapabilities
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(144);
    private static final Logger LOGGER = Logger.getLogger(UHFBandCapabilities.class);
    protected List<TransmitPowerLevelTableEntry> transmitPowerLevelTableEntryList = new LinkedList<TransmitPowerLevelTableEntry>();
    protected FrequencyInformation frequencyInformation;
    protected List<AirProtocolUHFRFModeTable> airProtocolUHFRFModeTableList = new LinkedList<AirProtocolUHFRFModeTable>();

    public UHFBandCapabilities() {
    }

    public UHFBandCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public UHFBandCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.transmitPowerLevelTableEntryList == null) {
            LOGGER.warn((Object)" transmitPowerLevelTableEntryList not set");
            throw new MissingParameterException(" transmitPowerLevelTableEntryList not set");
        }
        for (TransmitPowerLevelTableEntry transmitPowerLevelTableEntry : this.transmitPowerLevelTableEntryList) {
            resultBits.append(transmitPowerLevelTableEntry.encodeBinary());
        }
        if (this.frequencyInformation == null) {
            LOGGER.warn((Object)" frequencyInformation not set");
            throw new MissingParameterException(" frequencyInformation not set");
        }
        resultBits.append(this.frequencyInformation.encodeBinary());
        if (this.airProtocolUHFRFModeTableList == null) {
            LOGGER.warn((Object)" airProtocolUHFRFModeTableList not set");
            throw new MissingParameterException(" airProtocolUHFRFModeTableList not set");
        }
        for (AirProtocolUHFRFModeTable airProtocolUHFRFModeTable : this.airProtocolUHFRFModeTableList) {
            resultBits.append(airProtocolUHFRFModeTable.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        if (this.transmitPowerLevelTableEntryList == null) {
            LOGGER.warn((Object)" transmitPowerLevelTableEntryList not set");
            throw new MissingParameterException("  transmitPowerLevelTableEntryList not set");
        }
        for (TransmitPowerLevelTableEntry transmitPowerLevelTableEntry : this.transmitPowerLevelTableEntryList) {
            element.addContent(transmitPowerLevelTableEntry.encodeXML(transmitPowerLevelTableEntry.getClass().getName().replaceAll(transmitPowerLevelTableEntry.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.frequencyInformation == null) {
            LOGGER.info((Object)"frequencyInformation not set");
            throw new MissingParameterException("frequencyInformation not set");
        }
        element.addContent(this.frequencyInformation.encodeXML(this.frequencyInformation.getClass().getSimpleName(), ns));
        if (this.airProtocolUHFRFModeTableList == null) {
            LOGGER.warn((Object)" airProtocolUHFRFModeTableList not set");
            throw new MissingParameterException("  airProtocolUHFRFModeTableList not set");
        }
        for (AirProtocolUHFRFModeTable airProtocolUHFRFModeTable : this.airProtocolUHFRFModeTableList) {
            element.addContent(airProtocolUHFRFModeTable.encodeXML(airProtocolUHFRFModeTable.getClass().getName().replaceAll(airProtocolUHFRFModeTable.getClass().getPackage().getName() + ".", ""), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.transmitPowerLevelTableEntryList = new LinkedList<TransmitPowerLevelTableEntry>();
        LOGGER.debug((Object)"decoding parameter transmitPowerLevelTableEntryList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(TransmitPowerLevelTableEntry.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = TransmitPowerLevelTableEntry.length();
                }
                this.transmitPowerLevelTableEntryList.add(new TransmitPowerLevelTableEntry(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding TransmitPowerLevelTableEntry to transmitPowerLevelTableEntryList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.transmitPowerLevelTableEntryList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional transmitPowerLevelTableEntryList");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type TransmitPowerLevelTableEntry");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"UHFBandCapabilities misses non optional parameter of type FrequencyInformation");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type FrequencyInformation");
        }
        if (binary.get(position)) {
            UHFBandCapabilities uHFBandCapabilities = this;
            tempLength = uHFBandCapabilities.frequencyInformation.length();
        }
        if (type != null && type.equals(FrequencyInformation.TYPENUM)) {
            this.frequencyInformation = new FrequencyInformation(binary.subList(position, tempLength));
            position += tempLength;
        } else {
            LOGGER.warn((Object)"UHFBandCapabilities misses non optional parameter of type FrequencyInformation");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type FrequencyInformation");
        }
        LOGGER.debug((Object)(" frequencyInformation is instantiated with FrequencyInformation with length" + tempLength));
        this.airProtocolUHFRFModeTableList = new LinkedList<AirProtocolUHFRFModeTable>();
        LOGGER.debug((Object)"decoding parameter airProtocolUHFRFModeTableList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = new UnsignedShort(binary.subList(position + 6 + 10, UnsignedShort.length())).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2UHFRFModeTable.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2UHFRFModeTable.length();
                }
                this.airProtocolUHFRFModeTableList.add(new C1G2UHFRFModeTable(binary.subList(position, tempLength)));
                LOGGER.debug((Object)"adding C1G2UHFRFModeTable to airProtocolUHFRFModeTableList ");
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.airProtocolUHFRFModeTableList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional airProtocolUHFRFModeTableList");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type AirProtocolUHFRFModeTable");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        this.transmitPowerLevelTableEntryList = new LinkedList<TransmitPowerLevelTableEntry>();
        tempList = element.getChildren("TransmitPowerLevelTableEntry", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn((Object)"UHFBandCapabilities misses non optional parameter of type transmitPowerLevelTableEntryList");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type transmitPowerLevelTableEntryList");
        }
        for (Element e : tempList) {
            this.transmitPowerLevelTableEntryList.add(new TransmitPowerLevelTableEntry(e));
            LOGGER.debug((Object)"adding TransmitPowerLevelTableEntry to transmitPowerLevelTableEntryList ");
        }
        element.removeChildren("TransmitPowerLevelTableEntry", ns);
        temp = element.getChild("FrequencyInformation", ns);
        if (temp != null) {
            this.frequencyInformation = new FrequencyInformation(temp);
            LOGGER.info((Object)"setting parameter frequencyInformation for parameter UHFBandCapabilities");
        }
        if (temp == null) {
            LOGGER.warn((Object)"UHFBandCapabilities misses non optional parameter of type frequencyInformation");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type frequencyInformation");
        }
        element.removeChild("FrequencyInformation", ns);
        this.airProtocolUHFRFModeTableList = new LinkedList<AirProtocolUHFRFModeTable>();
        tempList = element.getChildren("C1G2UHFRFModeTable", ns);
        for (Element e : tempList) {
            this.airProtocolUHFRFModeTableList.add(new C1G2UHFRFModeTable(e));
            LOGGER.debug((Object)"adding C1G2UHFRFModeTable to airProtocolUHFRFModeTableList ");
            atLeastOnce = true;
        }
        element.removeChildren("C1G2UHFRFModeTable", ns);
        if (!atLeastOnce) {
            LOGGER.warn((Object)"UHFBandCapabilities misses non optional parameter of type airProtocolUHFRFModeTableList");
            throw new MissingParameterException("UHFBandCapabilities misses non optional parameter of type airProtocolUHFRFModeTableList");
        }
        atLeastOnce = false;
        if (element.getChildren().size() > 0) {
            String message = "UHFBandCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setTransmitPowerLevelTableEntryList(List<TransmitPowerLevelTableEntry> transmitPowerLevelTableEntryList) {
        this.transmitPowerLevelTableEntryList = transmitPowerLevelTableEntryList;
    }

    public void setFrequencyInformation(FrequencyInformation frequencyInformation) {
        this.frequencyInformation = frequencyInformation;
    }

    public void setAirProtocolUHFRFModeTableList(List<AirProtocolUHFRFModeTable> airProtocolUHFRFModeTableList) {
        this.airProtocolUHFRFModeTableList = airProtocolUHFRFModeTableList;
    }

    public List<TransmitPowerLevelTableEntry> getTransmitPowerLevelTableEntryList() {
        return this.transmitPowerLevelTableEntryList;
    }

    public FrequencyInformation getFrequencyInformation() {
        return this.frequencyInformation;
    }

    public List<AirProtocolUHFRFModeTable> getAirProtocolUHFRFModeTableList() {
        return this.airProtocolUHFRFModeTableList;
    }

    public void addToTransmitPowerLevelTableEntryList(TransmitPowerLevelTableEntry transmitPowerLevelTableEntry) {
        if (this.transmitPowerLevelTableEntryList == null) {
            this.transmitPowerLevelTableEntryList = new LinkedList<TransmitPowerLevelTableEntry>();
        }
        this.transmitPowerLevelTableEntryList.add(transmitPowerLevelTableEntry);
    }

    public void addToAirProtocolUHFRFModeTableList(AirProtocolUHFRFModeTable airProtocolUHFRFModeTable) {
        if (this.airProtocolUHFRFModeTableList == null) {
            this.airProtocolUHFRFModeTableList = new LinkedList<AirProtocolUHFRFModeTable>();
        }
        this.airProtocolUHFRFModeTableList.add(airProtocolUHFRFModeTable);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "UHFBandCapabilities";
    }

    public String toString() {
        String result = "UHFBandCapabilities: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

