/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPProtocolCodecFactory;

public class LLRPAcceptor
extends LLRPConnection {
    public static final int IDLE_TIME = 20;
    private static final Logger log = Logger.getLogger(LLRPAcceptor.class);
    private int port = 5084;
    private IoAcceptor acceptor;
    private InetSocketAddress socketAddress;

    public LLRPAcceptor() {
    }

    public LLRPAcceptor(LLRPEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, int port) {
        this.endpoint = endpoint;
        this.port = port;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, int port, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.port = port;
        this.handler = handler;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
    }

    public void bind() throws LLRPConnectionAttemptFailedException {
        this.bind(0L);
    }

    public void bind(long timeout) throws LLRPConnectionAttemptFailedException {
        this.acceptor = new SocketAcceptor();
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new LLRPProtocolCodecFactory(1)));
        SocketAcceptorConfig cfg = new SocketAcceptorConfig();
        cfg.getSessionConfig().setReceiveBufferSize(2048);
        try {
            this.socketAddress = new InetSocketAddress(this.port);
            this.acceptor.bind((SocketAddress)this.socketAddress, (IoHandler)this.handler);
            log.info((Object)("server listening on port " + this.port));
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new LLRPConnectionAttemptFailedException(e.getMessage());
        }
        if (timeout > 0L) {
            this.checkLLRPConnectionAttemptStatus(timeout);
        }
    }

    public void close() {
        this.acceptor.unbind((SocketAddress)this.socketAddress);
    }

    public boolean reconnect() {
        return false;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

