/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.llrp.ltk.generated.LLRPMessageFactory;
import org.llrp.ltk.types.LLRPMessage;

public class LLRPBinaryDecoder
extends CumulativeProtocolDecoder {
    private static final String MESSAGE_VERSION_KEY = "MessageVersion";
    private static final String MESSAGE_LENGTH_ARRAY = "LengthArray";
    private static final String MESSAGE_LENGTH_KEY = "MessageLength";
    private Logger log = Logger.getLogger(LLRPBinaryDecoder.class);

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        block8: {
            int length = -1;
            byte[] lengthArray = null;
            byte[] version = null;
            if (in.remaining() >= 6 && session.getAttribute(MESSAGE_LENGTH_KEY) == null) {
                this.log.debug((Object)"determine length of message");
                version = new byte[]{in.get(), in.get()};
                lengthArray = new byte[]{in.get(), in.get(), in.get(), in.get()};
                length = new BigInteger(lengthArray).intValue();
                session.setAttribute(MESSAGE_LENGTH_ARRAY, (Object)lengthArray);
                session.setAttribute(MESSAGE_LENGTH_KEY, (Object)new Integer(length));
                session.setAttribute(MESSAGE_VERSION_KEY, (Object)version);
                return in.remaining() >= length - 6;
            }
            if (session.getAttribute(MESSAGE_LENGTH_KEY) != null) {
                this.log.debug((Object)"length already determined, see if enough bytes are available");
                length = (Integer)session.getAttribute(MESSAGE_LENGTH_KEY);
                version = (byte[])session.getAttribute(MESSAGE_VERSION_KEY);
                lengthArray = (byte[])session.getAttribute(MESSAGE_LENGTH_ARRAY);
                if (in.remaining() >= length - 6) {
                    byte[] msg = new byte[length];
                    msg[0] = version[0];
                    msg[1] = version[1];
                    msg[2] = lengthArray[0];
                    msg[3] = lengthArray[1];
                    msg[4] = lengthArray[2];
                    msg[5] = lengthArray[3];
                    for (int i = 6; i < length; ++i) {
                        msg[i] = in.get();
                    }
                    this.log.debug((Object)"message completely received");
                    this.log.debug((Object)"start decoding message");
                    LLRPMessage message = LLRPMessageFactory.createLLRPMessage(msg);
                    this.log.debug((Object)("message decoded: " + message.getClass()));
                    out.write((Object)message);
                    session.removeAttribute(MESSAGE_LENGTH_ARRAY);
                    session.removeAttribute(MESSAGE_LENGTH_KEY);
                    session.removeAttribute(MESSAGE_VERSION_KEY);
                    try {
                        if (in.remaining() >= 6) {
                            version = new byte[]{in.get(), in.get()};
                            lengthArray = new byte[]{in.get(), in.get(), in.get(), in.get()};
                            length = new BigInteger(lengthArray).intValue();
                            session.setAttribute(MESSAGE_LENGTH_ARRAY, (Object)lengthArray);
                            session.setAttribute(MESSAGE_LENGTH_KEY, (Object)new Integer(length));
                            session.setAttribute(MESSAGE_VERSION_KEY, (Object)version);
                            if (in.remaining() - in.markValue() >= length - 6) {
                                this.log.debug((Object)"another message already in the buffer");
                                return true;
                            }
                            this.log.debug((Object)"message not yet completly delivered");
                            return false;
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        this.log.debug((Object)"not enough bytes to determine message length");
                        return false;
                    }
                }
                this.log.debug((Object)"not enough bytes to determine message length");
                return false;
            }
            this.log.debug((Object)"not enough bytes to determine length");
            return false;
        }
        return false;
    }
}

