/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPProtocolCodecFactory;

public class LLRPConnector
extends LLRPConnection {
    private Logger log = Logger.getLogger(LLRPConnector.class);
    private String host;
    private int port = 5084;
    private SocketConnector connector;
    private InetSocketAddress remoteAddress;

    public LLRPConnector() {
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, int port) {
        this.endpoint = endpoint;
        this.host = host;
        this.port = port;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host) {
        this.endpoint = endpoint;
        this.host = host;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.host = host;
    }

    public LLRPConnector(LLRPEndpoint endpoint, String host, int port, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.host = host;
        this.port = port;
    }

    public void connect() throws LLRPConnectionAttemptFailedException {
        this.connect(10000L);
    }

    public void connect(long timeout) throws LLRPConnectionAttemptFailedException {
        this.connector = new SocketConnector();
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new LLRPProtocolCodecFactory(1)));
        this.remoteAddress = new InetSocketAddress(this.host, this.port);
        ConnectFuture future = this.connector.connect((SocketAddress)this.remoteAddress, (IoHandler)this.handler);
        future.join();
        this.session = future.getSession();
        this.checkLLRPConnectionAttemptStatus(timeout);
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            CloseFuture closeFuture = this.session.close();
        }
    }

    public boolean reconnect() {
        ConnectFuture future = this.connector.connect((SocketAddress)this.remoteAddress, (IoHandler)this.handler);
        future.join();
        this.session = future.getSession();
        this.log.info((Object)("new session created:" + this.session));
        try {
            this.checkLLRPConnectionAttemptStatus(10000L);
        }
        catch (LLRPConnectionAttemptFailedException e) {
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

