/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class Bit
extends LLRPNumberType {
    private static final Integer LENGTH = 1;
    protected Integer value;

    public Bit() {
        this.value = 0;
        this.signed = false;
    }

    public Bit(int x) {
        if (!this.inRange(x)) {
            throw new IllegalArgumentException("value " + x + " not in range allowed for Bit");
        }
        this.value = x != 0 ? Integer.valueOf(1) : Integer.valueOf(0);
        this.signed = false;
    }

    public Bit(boolean x) {
        this.signed = x;
        this.value = x ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public Bit(Integer i) {
        this((int)i);
    }

    public Bit(String x) {
        if (!this.inRange(x)) {
            throw new IllegalArgumentException("value " + x + " not in range");
        }
        this.value = x.equalsIgnoreCase("0") ? Integer.valueOf(0) : Integer.valueOf(1);
        this.signed = false;
    }

    public Bit(LLRPBitList bitList) {
        this.value = bitList.get(0) ? Integer.valueOf(1) : Integer.valueOf(0);
        this.signed = false;
    }

    public Bit(Boolean bool) {
        this.value = bool != false ? Integer.valueOf(1) : Integer.valueOf(0);
        this.signed = false;
    }

    public Bit(Element element) {
        this.decodeXML(element);
    }

    public static int length() {
        return LENGTH;
    }

    public boolean toBoolean() {
        return !this.value.equals(0);
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    public Integer toInteger() {
        return new Integer(this.toByte());
    }

    public int intValue() {
        return this.toInteger();
    }

    public void decodeXML(Element element) {
        this.value = element.getText().equalsIgnoreCase("0") ? Integer.valueOf(0) : Integer.valueOf(1);
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.value.toString()));
        return element;
    }

    public void decodeBinary(LLRPBitList list) {
        this.value = list.get(0) ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(1);
        if (this.value != 0) {
            result.set(0);
        } else {
            result.clear(0);
        }
        return result;
    }

    public String toString() {
        if (this.value == 0) {
            return "0";
        }
        return "1";
    }

    public String toString(int radix) {
        return this.toString();
    }

    public boolean inRange(long value) {
        return value >= 0L && value <= 1L;
    }

    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

