/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.LinkedList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray;
import org.llrp.ltk.types.LLRPBitList;

public class BitArray_HEX
extends BitArray {
    public BitArray_HEX(Bit[] bits) {
        super(bits);
    }

    public BitArray_HEX(LLRPBitList list) {
        super(list);
    }

    public BitArray_HEX(int length) {
        super(length);
    }

    public BitArray_HEX() {
    }

    public BitArray_HEX(Element element) {
        super(element);
    }

    public BitArray_HEX(String hexString) {
        Element element = new Element("foo", "ns");
        element.setText(hexString);
        this.decodeXML(element);
    }

    public static int length() {
        return 1;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        String bitString = "";
        for (int i = 0; i < this.bits.length; ++i) {
            bitString = bitString + this.bits[i];
        }
        int mod = bitString.length() % 8;
        if (mod != 0) {
            element.setAttribute("Count", new Integer(bitString.length()).toString());
            for (int a = 0; a < 8 - mod; ++a) {
                bitString = "0" + bitString;
            }
        }
        String result = "";
        for (int i = 0; i < bitString.length(); i += 4) {
            result = result + Integer.toHexString(Integer.parseInt(bitString.substring(i, i + 4), 2));
        }
        element.setContent((Content)new Text(result));
        return element;
    }

    public void decodeXML(Element element) {
        String hexString = element.getText();
        String countString = element.getAttributeValue("Count");
        Integer count = countString != null ? Integer.valueOf(Integer.parseInt(countString)) : Integer.valueOf(hexString.length() * 4);
        LinkedList<Bit> tempList = new LinkedList<Bit>();
        int length = hexString.length();
        for (int a = 0; a < length; ++a) {
            int j;
            char hexDigit = hexString.charAt(a);
            Integer hexInt = Integer.parseInt(hexDigit + "", 16);
            String bitString = Integer.toBinaryString(hexInt);
            String padding = "";
            for (j = 0; j < 4 - bitString.length(); ++j) {
                padding = padding + "0";
            }
            bitString = padding + bitString;
            for (j = 0; j < bitString.length(); ++j) {
                tempList.add(new Bit(bitString.charAt(j) + ""));
            }
        }
        List shortenedList = tempList.subList(tempList.size() - count, tempList.size());
        Bit[] bs = new Bit[shortenedList.size()];
        this.bits = shortenedList.toArray(bs);
    }

    public String toString() {
        return this.encodeXML("foo", Namespace.getNamespace((String)"foo")).getValue();
    }
}

