/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;

public class BitList
extends LLRPType {
    private int length;
    private Bit[] bits;

    public BitList(Bit[] bits) {
        this.length = bits.length;
        this.bits = new Bit[bits.length];
        for (int i = 0; i < this.length; ++i) {
            this.bits[this.length - i - 1] = new Bit(bits[i].value);
        }
    }

    public BitList(String bitString) {
        this(bitString.length());
        this.setValue(Integer.parseInt(bitString, 2));
    }

    public BitList(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public BitList(Integer ... integers) {
        ArrayList<Bit> arrayList = new ArrayList<Bit>();
        for (Integer i : integers) {
            arrayList.add(new Bit(i));
        }
        this.bits = new Bit[arrayList.size()];
        int j = 0;
        Iterator i$ = arrayList.iterator();
        while (i$.hasNext()) {
            Bit b;
            this.bits[j] = b = (Bit)i$.next();
            ++j;
        }
        this.length = this.bits.length;
    }

    public BitList(int l) {
        this.bits = new Bit[l];
        for (int i = 0; i < l; ++i) {
            this.bits[i] = new Bit(false);
        }
        this.length = l;
    }

    public BitList(Integer l) {
        this.bits = new Bit[l.intValue()];
        for (int i = 0; i < l; ++i) {
            this.bits[i] = new Bit(false);
        }
        this.length = l;
    }

    public BitList() {
        this.bits = new Bit[1];
        this.length = 1;
    }

    public void setValue(int value) {
        String bitString = Integer.toBinaryString(value);
        int diff = 0;
        if (this.length > bitString.length()) {
            diff = this.length - bitString.length();
        } else {
            this.length = bitString.length();
            this.bits = new Bit[this.length];
        }
        for (int i = 0; i < bitString.length(); ++i) {
            this.bits[diff + i] = new Bit("" + bitString.charAt(i));
        }
    }

    public void clear(int i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i] = new Bit(false);
    }

    public void clear(Integer i) {
        this.clear((int)i);
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(this.bits.length);
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i].toBoolean()) {
                result.set(i);
                continue;
            }
            result.clear(i);
        }
        return result;
    }

    public int length() {
        return this.length;
    }

    public void decodeBinary(LLRPBitList list) {
        this.bits = new Bit[list.length()];
        for (int i = 0; i < list.length(); ++i) {
            this.bits[i] = new Bit(list.get(i));
        }
    }

    public Bit get(int i) {
        return this.bits[i];
    }

    public Bit get(Integer i) {
        return this.get((int)i);
    }

    public void set(int i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i] = new Bit(true);
    }

    public void set(Integer i) {
        this.set((int)i);
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    public void decodeXML(Element element) {
        String text = element.getText();
        this.bits = new Bit[text.length()];
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = new Bit(text.charAt(i));
        }
    }

    public Integer toInteger() {
        return Integer.parseInt(this.toString(), 2);
    }

    public int intValue() {
        return this.toInteger();
    }

    public String toString() {
        String s = "";
        for (Bit b : this.bits) {
            s = s + b.toInteger().toString();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    public String toString(int radix) {
        String s = "";
        for (Bit b : this.bits) {
            s = s + Integer.toString(b.toInteger(), radix);
        }
        return s;
    }

    public boolean inRange(String valueString) {
        for (int i = 0; i < valueString.length(); ++i) {
            try {
                new Bit(valueString.charAt(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

