/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.BitSet;
import org.llrp.ltk.types.SignedByte;

public class LLRPBitList {
    private BitSet bits;
    private Integer length;

    public LLRPBitList() {
        this.bits = new BitSet(0);
        this.bits.clear(0);
        this.length = 0;
    }

    public LLRPBitList(byte[] bytes) {
        this.bits = new BitSet(bytes.length * 8);
        this.length = bytes.length * 8;
        for (int i = 0; i < bytes.length; ++i) {
            Integer position = 8 * (i + 1);
            byte b = bytes[i];
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << j) > 0) {
                    this.bits.set(position - j - 1);
                    continue;
                }
                this.bits.clear(position + j);
            }
        }
    }

    public LLRPBitList(String bitString) {
        this.bits = new BitSet(bitString.length());
        this.length = bitString.length();
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(i) == '0') {
                this.bits.clear(i);
                continue;
            }
            this.bits.set(i);
        }
    }

    public LLRPBitList(int n) {
        this.bits = new BitSet(n);
        this.length = n;
    }

    public void add(boolean bit) {
        if (bit) {
            this.bits.set(this.length);
        } else {
            this.bits.clear(this.length);
        }
        Integer n = this.length;
        Integer n2 = this.length = Integer.valueOf(this.length + 1);
    }

    public void append(LLRPBitList other) {
        int oldLength = this.length;
        for (int i = 0; i < other.length; ++i) {
            Integer n = this.length;
            Integer n2 = this.length = Integer.valueOf(this.length + 1);
            if (other.bits.get(i)) {
                this.bits.set(oldLength + i);
                continue;
            }
            this.bits.clear(oldLength + i);
        }
    }

    public void clear(int position) {
        this.bits.clear(position);
    }

    public void clear(Integer i) {
        this.clear((int)i);
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        LLRPBitList n = new LLRPBitList();
        n.bits = (BitSet)this.bits.clone();
        n.length = this.length;
        return n;
    }

    public boolean equals(LLRPBitList other) {
        if (other.length.compareTo(this.length) != 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (!(this.get(i) ^ other.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean get(int position) {
        return this.bits.get(position);
    }

    public boolean get(Integer i) {
        return this.get((int)i);
    }

    public int length() {
        return this.length;
    }

    public void pad(int number) {
        BitSet n = new BitSet(number);
        for (int i = 0; i < this.length; ++i) {
            if (this.bits.get(i)) {
                n.set(number + i);
                continue;
            }
            n.clear(number + i);
        }
        this.length = this.length + number;
        this.bits = n;
    }

    public void pad(Integer i) {
        this.pad((int)i);
    }

    public void set(int position) {
        if (position > this.length) {
            this.length = position + 1;
        }
        this.bits.set(position);
    }

    public void set(Integer i) {
        this.set((int)i);
    }

    public LLRPBitList subList(Integer from, Integer subLength) {
        if (from < 0) {
            throw new IllegalArgumentException("illegal argument: trying to start sublist at negative position");
        }
        if (this.length < from + subLength) {
            throw new IllegalArgumentException("illegal argument: from plus sublist length longer than existing list");
        }
        LLRPBitList b = new LLRPBitList(subLength);
        for (int i = 0; i < subLength; ++i) {
            if (this.bits.get(from + i)) {
                b.set(i);
                continue;
            }
            b.clear(i);
        }
        return b;
    }

    public byte[] toByteArray() {
        Integer nOFb = this.length / 8;
        byte[] result = new byte[nOFb.intValue()];
        for (int i = 0; i < nOFb; ++i) {
            result[i] = new Byte(new SignedByte(this.subList(8 * i, 8)).toByte());
        }
        return result;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.length; ++i) {
            s = this.bits.get(i) ? s + "1" : s + "0";
        }
        return s;
    }

    public int hashCode() {
        return this.bits.hashCode();
    }
}

