/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedShort;

public class SignedIntegerArray
extends LLRPType {
    private SignedInteger[] integers;

    public SignedIntegerArray(SignedInteger[] ints) {
        this.integers = (SignedInteger[])ints.clone();
    }

    public SignedIntegerArray(Element element) {
        this.decodeXML(element);
    }

    public SignedIntegerArray(int length) {
        this.integers = new SignedInteger[length];
    }

    public SignedIntegerArray(int[] data) {
        this.integers = new SignedInteger[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.integers[i] = new SignedInteger(data[i]);
        }
    }

    public SignedIntegerArray(LLRPBitList bits) {
        this.decodeBinary(bits);
    }

    public SignedIntegerArray(String string) {
        Element element = new Element("foo", "ns");
        element.setText(string);
        this.decodeXML(element);
    }

    public SignedIntegerArray() {
        this.integers = new SignedInteger[0];
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(new UnsignedShort(this.integers.length).encodeBinary());
        for (int i = 0; i < this.integers.length; ++i) {
            result.append(this.integers[i].encodeBinary());
        }
        return result;
    }

    public int getByteLength() {
        return this.integers.length * 2;
    }

    public static int length() {
        return SignedInteger.length();
    }

    public void decodeBinary(LLRPBitList list) {
        Integer length = new SignedShort(list.subList(0, SignedShort.length())).toInteger();
        this.integers = new SignedInteger[length.intValue()];
        for (int i = 0; i < length; ++i) {
            this.integers[i] = new SignedInteger(list.subList(i * SignedInteger.length() + SignedShort.length(), SignedInteger.length()));
        }
    }

    public SignedInteger get(int i) {
        return this.integers[i];
    }

    public void set(int i, SignedInteger b) {
        if (i < 0 || i > this.integers.length) {
            return;
        }
        this.integers[i] = b;
    }

    public int size() {
        return this.integers.length;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    public void decodeXML(Element element) {
        String text = element.getText();
        if (!text.equals("")) {
            String[] strings = text.split(" ");
            this.integers = new SignedInteger[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                this.integers[i] = new SignedInteger(strings[i]);
            }
        } else {
            this.integers = new SignedInteger[0];
        }
    }

    public void add(SignedInteger aInteger) {
        SignedInteger[] newIntegers = new SignedInteger[this.integers.length + 1];
        System.arraycopy(this.integers, 0, newIntegers, 0, this.integers.length);
        newIntegers[this.integers.length] = aInteger;
        this.integers = newIntegers;
    }

    public String toString(int radix) {
        String s = "";
        for (SignedInteger b : this.integers) {
            s = s + b.toString(radix);
        }
        return s;
    }

    public String toString() {
        String s = "";
        for (SignedInteger b : this.integers) {
            s = s + " ";
            s = s + b.toInteger();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    public boolean inRange(String valueString) {
        String[] strings = valueString.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new SignedInteger(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(LLRPType other) {
        if (!(other instanceof SignedIntegerArray)) {
            throw new IllegalArgumentException("Argument not SignedIntegerArray");
        }
        SignedIntegerArray ba = (SignedIntegerArray)other;
        if (ba.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.integers.length; ++i) {
            if (ba.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }
}

