/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class SignedShort
extends LLRPNumberType {
    private static final Integer LENGTH = 16;
    protected Integer value;

    public SignedShort(Short value) {
        this.value = new Integer(value.shortValue());
        this.signed = true;
    }

    public SignedShort(Element element) {
        this.decodeXML(element);
    }

    public SignedShort(Integer value) {
        this.value = value;
        this.signed = true;
    }

    public SignedShort(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public SignedShort(int value) {
        this(new Integer(value));
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for SignedShort");
        }
    }

    public SignedShort() {
        this.value = 0;
        this.signed = true;
    }

    public SignedShort(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = true;
    }

    public SignedShort(String valueString) {
        this(valueString, 10);
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public void decodeBinary(LLRPBitList bitList) {
        String bitString = bitList.toString();
        if (bitString.length() == LENGTH.intValue() && bitString.charAt(0) == '1') {
            bitString = bitString.replaceAll("0", "#");
            bitString = bitString.replaceAll("1", "0");
            bitString = bitString.replaceAll("#", "1");
            bitString = bitString.replaceFirst("0", "");
            this.value = Integer.parseInt(bitString, 2) + 1;
            this.value = -this.value.intValue();
        } else {
            this.value = Integer.parseInt(bitString, 2);
        }
    }

    public static int length() {
        return LENGTH;
    }

    public Integer toInteger() {
        return new Integer(this.toShort());
    }

    public int intValue() {
        return this.toInteger();
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public void decodeXML(Element element) {
        this.value = Integer.parseInt(element.getText());
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.value.toString()));
        return element;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toString(int radix) {
        return Integer.toString(this.value, radix);
    }

    public boolean inRange(long value) {
        return value >= -32768L && value <= 32767L;
    }

    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

