/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;

public class TwoBitField
extends LLRPType {
    private static int length = 2;
    private Bit[] bits;

    public TwoBitField(Bit[] bits) {
        this.bits = new Bit[length];
        if (bits.length < 2) {
            this.bits[0] = new Bit(0);
            this.bits[1] = new Bit(0);
        } else {
            this.bits[0] = bits[0];
            this.bits[1] = bits[1];
        }
    }

    public TwoBitField(LLRPBitList list) {
        this.bits = new Bit[length];
        this.bits[0] = new Bit(0);
        this.bits[1] = new Bit(0);
        this.decodeBinary(list);
    }

    public TwoBitField(String string) {
        Element element = new Element("foo", "ns");
        element.setText(string);
        this.decodeXML(element);
        if (!this.inRange(this.toString(10))) {
            throw new IllegalArgumentException(string + " not in range allowed for TwoBitField");
        }
    }

    public TwoBitField() {
        this.bits = new Bit[length];
        this.bits[0] = new Bit(0);
        this.bits[1] = new Bit(0);
    }

    public TwoBitField(Element element) {
        this.decodeXML(element);
    }

    public void clear(Integer i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i.intValue()] = new Bit(0);
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(this.bits.length);
        Integer i = 0;
        while (i < length) {
            if (this.bits[i].toBoolean()) {
                result.set(i);
            } else {
                result.clear(i);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return result;
    }

    public static int length() {
        return length;
    }

    public void decodeBinary(LLRPBitList list) {
        this.bits = new Bit[length];
        Integer i = 0;
        while (i < length) {
            this.bits[i.intValue()] = new Bit(list.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public Bit get(Integer i) {
        return this.bits[i];
    }

    public int intValue() {
        String s = this.bits[1].toString() + "" + this.bits[0].toString();
        return new BigInteger(s, 2).intValue();
    }

    public void set(Integer i) {
        if (i < 0 || i > this.bits.length) {
            return;
        }
        this.bits[i.intValue()] = new Bit(true);
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeXML(Element element) {
        this.bits = new Bit[length];
        if (!element.getText().equals("")) {
            int i = Integer.parseInt(element.getText());
            if (i == 0) {
                this.bits[0] = new Bit(0);
                this.bits[1] = new Bit(0);
                return;
            } else if (i == 1) {
                this.bits[0] = new Bit(1);
                this.bits[1] = new Bit(0);
                return;
            } else if (i == 2) {
                this.bits[0] = new Bit(0);
                this.bits[1] = new Bit(1);
                return;
            } else {
                if (i != 3) throw new IllegalArgumentException(element.getText() + " not in range");
                this.bits[0] = new Bit(1);
                this.bits[1] = new Bit(1);
            }
            return;
        } else {
            this.bits[0] = new Bit(0);
            this.bits[1] = new Bit(0);
        }
    }

    public String toString() {
        Integer s = this.bits[0].toInteger() + this.bits[1].toInteger() * 2;
        return s.toString();
    }

    public String toString(int radix) {
        if (radix == 2) {
            return this.bits[0].toString() + "" + this.bits[1].toString();
        }
        return Integer.toString(this.intValue(), radix);
    }

    public boolean inRange(String valueString) {
        int i = Integer.parseInt(valueString);
        return i >= 0 && i <= 3;
    }
}

