/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedByte;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedShort;

public class UnsignedByteArray
extends LLRPType {
    protected UnsignedByte[] bytes;
    protected Integer value;
    protected boolean signed = false;

    public UnsignedByteArray(UnsignedByte[] bytes) {
        this.bytes = (UnsignedByte[])bytes.clone();
    }

    public UnsignedByteArray(Element element) {
        this.decodeXML(element);
    }

    public UnsignedByteArray(int length) {
        this.bytes = new UnsignedByte[length];
    }

    public UnsignedByteArray() {
        this.bytes = new UnsignedByte[0];
    }

    public UnsignedByteArray(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public UnsignedByteArray(byte[] bytes) {
        this.bytes = new UnsignedByte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            this.bytes[i] = new UnsignedByte(bytes[i]);
        }
    }

    public UnsignedByteArray(String byteString) {
        this.bytes = new UnsignedByte[byteString.length()];
        for (int i = 0; i < byteString.length(); ++i) {
            this.bytes[i] = new UnsignedByte(byteString.substring(i, i + 1));
        }
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(new UnsignedShort(this.bytes.length).encodeBinary());
        for (int i = 0; i < this.bytes.length; ++i) {
            result.append(this.bytes[i].encodeBinary());
        }
        return result;
    }

    public int getByteLength() {
        return this.bytes.length;
    }

    public static int length() {
        return SignedByte.length();
    }

    public void decodeBinary(LLRPBitList list) {
        Integer length = new SignedShort(list.subList(0, SignedShort.length())).toInteger();
        this.bytes = new UnsignedByte[length.intValue()];
        for (int i = 1; i <= length; ++i) {
            this.bytes[i - 1] = new UnsignedByte(list.subList((i + 1) * UnsignedByte.length(), UnsignedByte.length()));
        }
    }

    public UnsignedByte get(int i) {
        return this.bytes[i];
    }

    public void set(int i, UnsignedByte b) {
        if (i < 0 || i > this.bytes.length) {
            return;
        }
        this.bytes[i] = b;
    }

    public int size() {
        return this.bytes.length;
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    public void decodeXML(Element element) {
        String text = element.getText();
        if (text == null || text.equals("")) {
            this.bytes = new UnsignedByte[0];
            return;
        }
        String[] strings = text.split(" ");
        this.bytes = new UnsignedByte[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            this.bytes[i] = new UnsignedByte(strings[i]);
        }
    }

    public void add(UnsignedByte aByte) {
        UnsignedByte[] newBytes = new UnsignedByte[this.bytes.length + 1];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        newBytes[this.bytes.length] = aByte;
        this.bytes = newBytes;
    }

    public Integer toInteger() {
        String s = "";
        for (UnsignedByte b : this.bytes) {
            s = s + b.toString(16);
        }
        BigInteger big = new BigInteger(s, 16);
        return big.intValue();
    }

    public String toString(int radix) {
        String s = "";
        for (UnsignedByte b : this.bytes) {
            s = s + b.toString(radix);
        }
        return s;
    }

    public String toString() {
        String s = "";
        for (UnsignedByte b : this.bytes) {
            s = s + b.toInteger().toString();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    public boolean inRange(String valueString) {
        String[] strings = valueString.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new UnsignedByte(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

