/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.UnsignedByte;

public class UnsignedByte_HEX
extends UnsignedByte {
    private static final Integer LENGTH = 8;

    public UnsignedByte_HEX(int value) {
        this.value = value < 0 ? 254 + value + 2 : value;
        this.signed = false;
        if (!this.inRange(this.value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for UnsignedByte_HEX");
        }
    }

    public UnsignedByte_HEX(byte value) {
        this((int)value);
    }

    public UnsignedByte_HEX(String valueString) {
        this(Integer.parseInt(valueString, 16));
        if (!this.inRange(this.value)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public UnsignedByte_HEX(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public UnsignedByte_HEX() {
        this.value = 0;
        this.signed = false;
    }

    public UnsignedByte_HEX(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public UnsignedByte_HEX(Element element) {
        this.decodeXML(element);
    }

    public void decodeXML(Element element) {
        this.value = Integer.parseInt(element.getText(), 16);
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(Integer.toHexString(this.value)));
        return element;
    }

    public String toString(int radix) {
        return Integer.toString(this.value, radix).replace("-", "");
    }

    public String toString() {
        return this.toString(16);
    }
}

