/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedShort
extends LLRPNumberType {
    private static final Integer LENGTH = 16;
    protected Integer value;

    public UnsignedShort(Short value) {
        this.value = value & 0xFFFFFFFF;
        this.signed = false;
    }

    public UnsignedShort(int value) {
        this.value = value < 0 ? Integer.valueOf(65534 + value + 2) : Integer.valueOf(value);
        this.signed = false;
        if (!this.inRange(this.value.intValue())) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for UnsignedShort");
        }
    }

    public UnsignedShort(Element element) {
        this.decodeXML(element);
    }

    public UnsignedShort() {
        this.value = 0;
        this.signed = false;
    }

    public UnsignedShort(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public UnsignedShort(Integer value) {
        this((int)value);
    }

    public UnsignedShort(String valueString) {
        this.value = new Integer(valueString);
        this.signed = false;
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public UnsignedShort(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    public static int length() {
        return LENGTH;
    }

    public Integer toInteger() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public void decodeBinary(LLRPBitList list) {
        this.value = Integer.parseInt(list.toString(), 2);
    }

    public void decodeXML(Element element) {
        this.value = new Integer(element.getText());
    }

    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.value.toString()));
        return element;
    }

    public String toString(int radix) {
        return Integer.toString(this.value & 0xFFFF, radix);
    }

    public boolean inRange(long value) {
        int max = 65535;
        return value >= 0L && value <= (long)max;
    }

    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

