/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.LLRPMessageFactory;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;

public class Util {
    static final Logger LOGGER = Logger.getLogger((String)"Util.class");

    public static LLRPBitList loadBinaryFileContent(File file) throws IOException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        LLRPBitList bitlist = new LLRPBitList();
        while (bis.available() > 0) {
            byte[] bytes = new byte[bis.available()];
            int length = bis.read(bytes);
            bitlist.append(new LLRPBitList(bytes));
        }
        fis.close();
        bis.close();
        return bitlist;
    }

    public static String loadTextFileContent(File file) throws IOException, FileNotFoundException {
        FileReader fis = null;
        BufferedReader bis = null;
        StringBuffer buffer = new StringBuffer();
        fis = new FileReader(file);
        bis = new BufferedReader(fis);
        String line = bis.readLine();
        while (line != null) {
            buffer.append(line);
            line = bis.readLine();
        }
        return buffer.toString();
    }

    public static LLRPMessage loadBinaryLLRPMessage(File file) throws FileNotFoundException, IOException, InvalidLLRPMessageException {
        LLRPBitList bits = Util.loadBinaryFileContent(file);
        LOGGER.debug((Object)("Loaded binary message: " + bits));
        LLRPMessage message = LLRPMessageFactory.createLLRPMessage(bits);
        return message;
    }

    public static LLRPMessage loadXMLLLRPMessage(File file) throws FileNotFoundException, IOException, JDOMException, InvalidLLRPMessageException {
        Document doc = new SAXBuilder().build((Reader)new FileReader(file));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        LOGGER.debug((Object)("Loaded XML Message: " + outputter.outputString(doc)));
        LLRPMessage message = LLRPMessageFactory.createLLRPMessage(doc);
        return message;
    }
}

